/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import dmonner.xlbp.util.ArrayQueue;
import dmonner.xlbp.util.IndexAwareHeap;
import dmonner.xlbp.util.IndexAwareHeapNode;
import java.util.Comparator;

public class SlidingMedian {
    private final boolean uniqueMedian;
    private final IndexAwareHeap<Float> less;
    private final IndexAwareHeap<Float> more;
    private final ArrayQueue<IndexAwareHeapNode<Float>> samples;

    public static void main(String[] args) {
        SlidingMedian m = new SlidingMedian(11);
        for (int i = 1; i <= 50; ++i) {
            int n = (int)(Math.random() * 50.0);
            m.update(n);
            System.out.println(n);
            System.out.println(m);
            System.out.println();
        }
    }

    public SlidingMedian(int window) {
        this(window, 0.0f);
    }

    public SlidingMedian(int window, float defaultMedian) {
        int i;
        this.uniqueMedian = window % 2 == 1;
        int lessSize = window / 2;
        int moreSize = window / 2 + (this.uniqueMedian ? 1 : 0);
        Comparator<Float> reverseComp = new Comparator<Float>(){

            @Override
            public int compare(Float a, Float b) {
                float result = b.floatValue() - a.floatValue();
                if (result > 0.0f) {
                    return 1;
                }
                if (result < 0.0f) {
                    return -1;
                }
                return 0;
            }
        };
        this.samples = new ArrayQueue(window);
        this.less = new IndexAwareHeap(lessSize);
        for (i = 0; i < lessSize; ++i) {
            this.samples.push(this.less.add(Float.valueOf(defaultMedian)));
        }
        this.more = new IndexAwareHeap<Float>(moreSize, reverseComp);
        for (i = 0; i < moreSize; ++i) {
            this.samples.push(this.more.add(Float.valueOf(defaultMedian)));
        }
    }

    public float get() {
        if (this.uniqueMedian) {
            return this.more.peek().floatValue();
        }
        return (this.less.peek().floatValue() + this.more.peek().floatValue()) / 2.0f;
    }

    public IndexAwareHeapNode<Float> getSample(int index) {
        return this.samples.peek(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("med  = " + this.get() + "\n");
        sb.append("less = " + this.less + "\n");
        sb.append("more = " + this.more + "\n");
        return sb.toString();
    }

    public void update(float sample) {
        IndexAwareHeapNode<Float> out = this.samples.pop();
        IndexAwareHeapNode<Float> in = new IndexAwareHeapNode<Float>(Float.valueOf(sample));
        this.samples.push(in);
        this.update(in, out);
    }

    public void update(IndexAwareHeapNode<Float> in, IndexAwareHeapNode<Float> out) {
        if (out.getHeap() == this.less) {
            if (((Float)in.element).floatValue() <= this.more.peek().floatValue()) {
                this.less.remove(out);
                this.less.add(in);
            } else {
                this.less.remove(out);
                this.less.add(this.more.remove());
                this.more.add(in);
            }
        } else if (((Float)in.element).floatValue() >= this.less.peek().floatValue()) {
            this.more.remove(out);
            this.more.add(in);
        } else {
            this.more.remove(out);
            this.more.add(this.less.remove());
            this.less.add(in);
        }
    }
}

