/*
 * Decompiled with CFR 0.152.
 */
package zezinho;

import zezinho.QueueADT;

public class CircularQueueArray<T>
implements QueueADT<T> {
    private final int DEFAULT_CAPACITY = 100;
    private int front;
    private int rear;
    private int count;
    private int lastInserted;
    private T[] queue;

    public CircularQueueArray() {
        this.lastInserted = 0;
        this.count = 0;
        this.rear = 0;
        this.front = 0;
        this.queue = new Object[100];
    }

    public CircularQueueArray(int initialCapacity) {
        this.count = 0;
        this.rear = 0;
        this.front = 0;
        this.queue = new Object[initialCapacity];
    }

    @Override
    public void enqueue(T element) {
        if (this.size() == this.queue.length) {
            this.expandCapacity();
        }
        this.queue[this.rear] = element;
        this.lastInserted = this.rear;
        this.rear = (this.rear + 1) % this.queue.length;
        ++this.count;
    }

    public T get(int i) {
        return this.queue[(this.front + i) % this.queue.length];
    }

    public T getLastInserted() {
        return this.queue[this.lastInserted];
    }

    @Override
    public T dequeue() {
        T result = this.queue[this.front];
        this.queue[this.front] = null;
        this.front = (this.front + 1) % this.queue.length;
        --this.count;
        return result;
    }

    @Override
    public T first() {
        return this.queue[this.front];
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        String result = "";
        for (int scan = 0; scan < this.count; ++scan) {
            if (this.queue[scan] == null) continue;
            result = result + this.queue[scan].toString() + "\n";
        }
        return result;
    }

    public void expandCapacity() {
        System.err.println("Im expanding");
        Object[] larger = new Object[this.queue.length * 2];
        for (int scan = 0; scan < this.count; ++scan) {
            larger[scan] = this.queue[this.front];
            this.front = (this.front + 1) % this.queue.length;
        }
        this.front = 0;
        this.rear = this.count;
        this.queue = larger;
    }
}

