/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane.gun;

import jdw.hurricane.Enemy;

public class LinkedRobotState {
    public final double x;
    public final double y;
    public final LinkedRobotState prev;
    public LinkedRobotState next;
    public double[] point;

    public LinkedRobotState(LinkedRobotState _prev, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.prev = _prev;
        if (this.prev != null) {
            this.prev.next = this;
        }
    }

    public LinkedRobotState interpolate_to(int time_diff, double this_x_vel, double this_y_vel, double new_x, double new_y, double new_x_vel, double new_y_vel) {
        double inc;
        LinkedRobotState cursor = this;
        double x2 = this.x + this_x_vel * (double)time_diff / 3.0;
        double y2 = this.y + this_y_vel * (double)time_diff / 3.0;
        double x3 = new_x - new_x_vel * (double)time_diff / 3.0;
        double y3 = new_y - new_y_vel * (double)time_diff / 3.0;
        double t1 = inc = 1.0 / (double)time_diff;
        while (time_diff-- != 0) {
            double t2 = 1.0 - t1;
            double t_x = 1.0 * t2 * t2 * t2 * this.x + 3.0 * t2 * t2 * t1 * x2 + 3.0 * t2 * t1 * t1 * x3 + 1.0 * t1 * t1 * t1 * new_x;
            double t_y = 1.0 * t2 * t2 * t2 * this.y + 3.0 * t2 * t2 * t1 * y2 + 3.0 * t2 * t1 * t1 * y3 + 1.0 * t1 * t1 * t1 * new_y;
            cursor = new LinkedRobotState(cursor, t_x, t_y);
            t1 += inc;
        }
        return cursor;
    }

    public double[] get_fire_pos(double fire_x, double fire_y, int fire_ticks, double bullet_vel, Enemy cur) {
        double bd;
        if (this.next == null) {
            return null;
        }
        double d = Math.sqrt(cur.x_vel * cur.x_vel + cur.y_vel * cur.y_vel);
        double sinr = cur.x_vel / d;
        double cosr = cur.y_vel / d;
        double rx = this.next.x - this.x;
        double ry = this.next.y - this.y;
        d = Math.sqrt(rx * rx + ry * ry);
        rx /= d;
        ry /= d;
        d = cosr * rx - sinr * ry;
        cosr = sinr * rx + cosr * ry;
        sinr = d;
        rx = fire_x - cur.x;
        ry = fire_y - cur.y;
        fire_x = cosr * rx + sinr * ry + this.x;
        fire_y = -sinr * rx + cosr * ry + this.y;
        LinkedRobotState cursor = this;
        int i = 0;
        int targ = 8;
        do {
            targ <<= 1;
            while (i < targ) {
                cursor = cursor.next;
                if (cursor == null) {
                    return null;
                }
                ++i;
            }
        } while ((bd = (double)(i - fire_ticks) * bullet_vel) * bd < (rx = cursor.x - fire_x) * rx + (ry = cursor.y - fire_y) * ry);
        boolean go_prev = true;
        int error = i;
        if (error != 16) {
            error >>= 1;
        }
        while (error != 1) {
            error >>= 1;
            if (go_prev) {
                targ -= error;
                while (i > targ) {
                    cursor = cursor.prev;
                    --i;
                }
            } else {
                targ += error;
                while (i < targ) {
                    cursor = cursor.next;
                    ++i;
                }
            }
            rx = cursor.x - fire_x;
            ry = cursor.y - fire_y;
            bd = (double)(i - fire_ticks) * bullet_vel;
            boolean bl = go_prev = bd * bd > rx * rx + ry * ry;
        }
        if (go_prev) {
            cursor = cursor.prev;
        }
        rx = cursor.x - this.x;
        ry = cursor.y - this.y;
        fire_x = cosr * rx - sinr * ry + cur.x;
        fire_y = sinr * rx + cosr * ry + cur.y;
        rx = cursor.next.x - cursor.x;
        ry = cursor.next.y - cursor.y;
        double vel_x = cosr * rx - sinr * ry;
        double vel_y = sinr * rx + cosr * ry;
        return new double[]{fire_x, fire_y, vel_x, vel_y};
    }
}

