/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.drive;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.math.LinearEquation;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;

public class IdealPositionDrive
implements Drive {
    private RobotProxy robot;
    private Rectangle2D.Double idealBounds;
    private Rectangle2D.Double battlefieldBounds;
    private double adjustRange = 300.0;
    private LinearEquation offsetAdjustEq = new LinearEquation(this.adjustRange, 0.0, 120.0, 90.0, 0.0, 90.0);

    public IdealPositionDrive() {
        this.robot = Resources.getRobotProxy();
        this.battlefieldBounds = this.robot.getBattleFieldSize();
        this.idealBounds = RCMath.shrink(this.battlefieldBounds, 40.0);
    }

    @Override
    public String getName() {
        return "Ideal Position Drive";
    }

    @Override
    public void onRoundBegin() {
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        Point2D counterPosition = this.getIdealCounterPosition(opponentSnapshot.getX(), opponentSnapshot.getY());
        double angleToDrive = RCMath.getRobocodeAngle(this.robot.getX(), this.robot.getY(), counterPosition.getX(), counterPosition.getY());
        if (opponentSnapshot.getDistance() < this.adjustRange) {
            double bearing = RCMath.getRobocodeAngle(this.robot.getX(), this.robot.getY(), opponentSnapshot.getX(), opponentSnapshot.getY());
            double offset = RCMath.getTurnAngle(angleToDrive, bearing);
            double minOffset = this.offsetAdjustEq.getY(opponentSnapshot.getDistance());
            if (Math.abs(offset) < minOffset) {
                double diff = minOffset - Math.abs(offset);
                angleToDrive = offset < 0.0 ? RCMath.normalizeDegrees(angleToDrive + diff) : RCMath.normalizeDegrees(angleToDrive - diff);
            }
        }
        driveController.drive(angleToDrive, 8.0);
    }

    @Override
    public void drive(DriveController driveController) {
        if (this.robot.getOthers() == 0) {
            driveController.drive(0.0, 0.0);
        } else {
            double angleToDrive = RCMath.getRobocodeAngleToCenter(this.robot.getX(), this.robot.getY(), this.battlefieldBounds);
            driveController.drive(angleToDrive, 8.0);
        }
    }

    public Point2D getIdealCounterPosition(double opponentX, double opponentY) {
        double oppAngleToCenter = RCMath.getRobocodeAngleToCenter(opponentX, opponentY, this.battlefieldBounds);
        double dist = RCMath.getDistanceToIntersect(opponentX, opponentY, oppAngleToCenter, this.battlefieldBounds);
        Point2D.Double target = RCMath.getLocation(opponentX, opponentY, dist / 2.0, oppAngleToCenter);
        target.x = RCMath.limit(target.x, this.idealBounds.getMinX(), this.idealBounds.getMaxX());
        target.y = RCMath.limit(target.y, this.idealBounds.getMinY(), this.idealBounds.getMaxY());
        return target;
    }
}

