/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.drive;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.DistancingEquation;
import xander.core.math.RCMath;
import xander.core.track.GunStats;
import xander.core.track.Wave;

public class SmartDistancingEquation
extends DistancingEquation {
    private GunStats gunStats;
    private RobotProxy robotProxy;
    private double beginAdjustHitRatio = 0.12;
    private double zeroAdjustHitRatio = 0.1;
    private double hrRange = this.beginAdjustHitRatio - this.zeroAdjustHitRatio;

    public SmartDistancingEquation(double maxRetreatDistance, double optimalDistance, double maxAdvanceDistance, double maxRetreatAngle, double maxAdvanceAngle) {
        super(maxRetreatDistance, optimalDistance, maxAdvanceDistance, maxRetreatAngle, maxAdvanceAngle);
        this.robotProxy = Resources.getRobotProxy();
        this.gunStats = Resources.getGunStats();
    }

    public void setMyHitRatioThresholds(double beginAdjustHitRatio, double zeroAdjustHitRatio) {
        this.beginAdjustHitRatio = beginAdjustHitRatio;
        this.zeroAdjustHitRatio = zeroAdjustHitRatio;
        this.hrRange = beginAdjustHitRatio - zeroAdjustHitRatio;
    }

    @Override
    public double getAdjustAngle(double distance, Wave wave) {
        double adjustAngle = super.getAdjustAngle(distance, wave);
        if (this.robotProxy.getRoundNum() > 1) {
            double myHitRatio = this.gunStats.getOverallHitRatio();
            double oppHitRatio = this.gunStats.getOverallOpponentHitRatio();
            if (myHitRatio < this.beginAdjustHitRatio && oppHitRatio > myHitRatio) {
                adjustAngle *= Math.max(0.0, myHitRatio - this.zeroAdjustHitRatio) / this.hrRange;
            }
            if (distance < this.getOptimalDistance() && wave != null) {
                double waveApproachAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), this.robotProxy.getX(), this.robotProxy.getY());
                double distanceToWall = RCMath.getDistanceToIntersect(this.robotProxy.getX(), this.robotProxy.getY(), waveApproachAngle, this.robotProxy.getBattleFieldSize());
                if (distanceToWall < 40.0) {
                    adjustAngle = 0.0;
                }
            }
        }
        return adjustAngle;
    }
}

