/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.mirror;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import xander.cat.group.mirror.MirrorPlan;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.math.RCMath;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;

public class AntiMirrorDrive
implements Drive {
    public static final double DRIVE_SPEED = 8.0;
    private MirrorPlan mirrorPlan;
    private RobotProxy robotProxy;
    private OrbitalDrivePredictor orbitalDriver;

    public AntiMirrorDrive(MirrorPlan mirrorPlan, OrbitalDrivePredictor orbitalDriver) {
        this.orbitalDriver = orbitalDriver;
        this.mirrorPlan = mirrorPlan;
        this.robotProxy = Resources.getRobotProxy();
    }

    @Override
    public String getName() {
        return "Anti-Mirror Drive";
    }

    @Override
    public void onRoundBegin() {
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        this.drive(driveController);
    }

    public static Point2D.Double getOrbitCenter(double x, double y, Rectangle2D.Double battlefieldBounds) {
        double angleToCenter = RCMath.getRobocodeAngleToCenter(x, y, battlefieldBounds);
        double distance = RCMath.getDistanceToIntersect(x, y, angleToCenter, battlefieldBounds);
        return RCMath.getLocation(x, y, distance, angleToCenter);
    }

    @Override
    public void drive(DriveController driveController) {
        Direction direction = this.mirrorPlan.getDirection(this.robotProxy.getTime());
        Point2D.Double center = AntiMirrorDrive.getOrbitCenter(this.robotProxy.getX(), this.robotProxy.getY(), this.robotProxy.getBattleFieldSize());
        VelocityVector orbitVector = this.orbitalDriver.getSmoothedOrbitAngle(center, 100.0, direction, DistancingEquation.NO_ADJUST, 8.0);
        driveController.drive(orbitVector.getRoboAngle(), orbitVector.getMagnitude());
    }
}

