/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import java.util.HashMap;
import java.util.Map;
import xander.core.Resources;
import xander.core.gun.Gun;
import xander.core.gun.GunSelector;
import xander.core.math.ConstantValueFunction;
import xander.core.math.Function;
import xander.core.math.RCRoundFunction;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;

public class VirtualHitRatioGunSelector
implements GunSelector {
    private GunStats gunStats;
    private Map<Gun, Double> biasMap = new HashMap<Gun, Double>();
    private RCRoundFunction rollingRatioWeightFunction = new RCRoundFunction(new ConstantValueFunction(0.6));
    private Gun preferredGun;
    private double preferredHitRatio;
    private int usePreferredGunOnlyUntilRound;

    public VirtualHitRatioGunSelector() {
        this.gunStats = Resources.getGunStats();
    }

    public void setRollingRatioWeight(double rollingRatioWeight) {
        this.rollingRatioWeightFunction = new RCRoundFunction(new ConstantValueFunction(rollingRatioWeight));
    }

    public void setRollingRatioWeightFunction(Function rollingRatioWeightFunction) {
        this.rollingRatioWeightFunction = new RCRoundFunction(rollingRatioWeightFunction);
    }

    public void setRollingRatioWeightFunction(RCRoundFunction rollingRatioWeightFunction) {
        this.rollingRatioWeightFunction = rollingRatioWeightFunction;
    }

    public void addBias(Gun gun, double bias) {
        this.biasMap.put(gun, bias);
    }

    public void setPreferredGun(Gun gun, double hitRatio, int usePreferredGunOnlyUntilRound) {
        this.preferredGun = gun;
        this.preferredHitRatio = hitRatio;
        this.usePreferredGunOnlyUntilRound = usePreferredGunOnlyUntilRound;
    }

    @Override
    public int selectGun(Gun[] guns, Snapshot target) {
        int sGunIndex = 0;
        double rollingRatioWeight = this.rollingRatioWeightFunction.getValueForRound();
        double sRatio = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < guns.length) {
            Gun gun = guns[i];
            double ratio = this.gunStats.getVirtualHitRatio(gun.getName());
            double rollingRatio = this.gunStats.getRollingVirtualHitRatio(gun.getName());
            ratio = ratio * (1.0 - rollingRatioWeight) + rollingRatio * rollingRatioWeight;
            Double bias = this.biasMap.get(gun);
            if (bias != null) {
                ratio += bias.doubleValue();
            }
            if (ratio > sRatio && guns[i].canFireAt(target) || gun == this.preferredGun && (ratio > this.preferredHitRatio || Resources.getRobotProxy().getRoundNum() < this.usePreferredGunOnlyUntilRound)) {
                sGunIndex = i;
                sRatio = ratio;
            }
            ++i;
        }
        return sGunIndex;
    }
}

