/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import xander.core.Resources;
import xander.core.gun.AbstractGun;
import xander.core.gun.Aim;
import xander.core.gun.power.PowerSelector;
import xander.core.gun.targeter.Targeter;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.WaveHistory;

public class XanderGun
extends AbstractGun {
    private static final Log log = Logger.getLog(XanderGun.class);
    private Targeter targeter;
    private PowerSelector powerSelector;
    private WaveHistory waveHistory;
    private String gunName;
    private double minEnergyToFire = 0.5;
    private double lowEnergyConservationRate = 1.0;

    public XanderGun(String gunName, Targeter targeter, PowerSelector powerSelector) {
        this.gunName = gunName;
        this.targeter = targeter;
        this.powerSelector = powerSelector;
        this.waveHistory = Resources.getWaveHistory();
    }

    public XanderGun(Targeter targeter, PowerSelector powerSelector) {
        this(null, targeter, powerSelector);
    }

    public double getMinEnergyToFire() {
        return this.minEnergyToFire;
    }

    public void setMinEnergyToFire(double minEnergyToFire) {
        this.minEnergyToFire = minEnergyToFire;
    }

    public double getLowEnergyConservationRate() {
        return this.lowEnergyConservationRate;
    }

    public void setLowEnergyConservationRate(double lowEnergyConservationRate) {
        this.lowEnergyConservationRate = lowEnergyConservationRate;
    }

    @Override
    public String getName() {
        return this.gunName == null ? String.valueOf(this.targeter.getTargetingType()) + " Xander Gun" : this.gunName;
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        return this.targeter.canAimAt(target);
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        Aim aim = null;
        if (this.targeter.canAimAt(target)) {
            Wave wave;
            double aimHeading;
            if (this.robotProxy.getTime() != target.getTime()) {
                log.warn(String.valueOf(this.getName()) + " aiming with old target data (from " + (this.robotProxy.getTime() - target.getTime()) + " ticks ago)");
            }
            double[] myNextXY = myself.getNextXY();
            Snapshot myselfP1 = myself.advance(myNextXY[0], myNextXY[1]);
            Snapshot targetP1 = target.advance(myself.getX(), myself.getY());
            double firePower = this.powerSelector.getFirePower(targetP1);
            if (this.powerSelector.isAutoAdjustAllowed()) {
                double availableFiringEnergy = this.robotProxy.getEnergy() - this.minEnergyToFire;
                firePower = Math.min(firePower, availableFiringEnergy * this.lowEnergyConservationRate);
                firePower = Math.min(firePower, RCPhysics.getFirePowerToKill(targetP1.getEnergy()));
            }
            if (firePower > 0.09 && firePower < this.robotProxy.getEnergy() && (aimHeading = this.targeter.getAim(targetP1, myselfP1, wave = this.waveHistory.createWave(target, myself, firePower, Resources.getTime(), false, false))) >= 0.0) {
                aim = new Aim(aimHeading, firePower);
            }
        }
        return aim;
    }
}

