/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.util.List;
import xander.paint.Paintable;

public abstract class GraphData
implements Paintable {
    private String painterName;
    private double[] dataPoints;
    private double maxValue;
    private int startIndex;
    private int lastIndex;

    public GraphData(String painterName, int numDataPoints) {
        this.painterName = painterName;
        this.dataPoints = new double[numDataPoints];
        this.lastIndex = numDataPoints - 1;
    }

    @Override
    public String getPainterName() {
        return this.painterName;
    }

    public abstract String getYAxisLabel();

    public abstract String getXAxisLabel();

    public abstract List<HorizontalRule> getHorizontalRules();

    protected void rollStartIndex() {
        ++this.startIndex;
        ++this.lastIndex;
        if (this.startIndex >= this.dataPoints.length) {
            this.startIndex = 0;
        }
        if (this.lastIndex >= this.dataPoints.length) {
            this.lastIndex = 0;
        }
    }

    protected void setDataPoint(int index, double value) {
        this.dataPoints[index] = value;
        if (value > this.maxValue) {
            this.maxValue = value;
        }
    }

    protected void setRolledDataPoint(double value) {
        this.setDataPoint(this.lastIndex, value);
    }

    public double[] getDataPoints() {
        return this.dataPoints;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public static class HorizontalRule {
        public String description;
        public double y;
        public Color color;

        public HorizontalRule(double y, Color color, String description) {
            this.y = y;
            this.color = color;
            this.description = description;
        }
    }
}

