/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.modifier;

import java.util.HashMap;
import java.util.Map;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.FactorIndexer;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.modifier.FactorArrayModifier;

public abstract class AbstractFactorArrayModifier
implements FactorArrayModifier {
    protected RobotProxy robotProxy;
    private WeightDistributer weightDistributer;
    private SnapshotHistory snapshotHistory;
    private double weight;
    private Map<Wave, Double> indicies = new HashMap<Wave, Double>();
    int arraySize;

    public AbstractFactorArrayModifier(WeightDistributer weightDistributer, double weight) {
        this.weightDistributer = weightDistributer;
        this.weight = weight;
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
    }

    public void setWeightDistributer(WeightDistributer weightDistributer) {
        this.weightDistributer = weightDistributer;
    }

    protected abstract double getModifyFactorAngle(double[] var1, Wave var2);

    @Override
    public void modify(double[] array, Wave wave) {
        double factorAngle;
        this.arraySize = array.length;
        FactorIndexer factorIndexer = wave.getFactorIndexer();
        double preciseIndex = factorIndexer.getPreciseFactorIndex(factorAngle = this.getModifyFactorAngle(array, wave), array.length, wave.getSurfDirection(), wave.getInitialMEA());
        if (preciseIndex >= 0.0) {
            this.indicies.put(wave, preciseIndex);
            Snapshot defender = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            double distance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), defender.getX(), defender.getY());
            this.weightDistributer.addWeight(array, preciseIndex, this.weight, distance, wave.getBulletVelocity(), wave.getSurfDirection());
        }
    }
}

