/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Targetable;
import pedersen.debug.GraphicalDebugger;
import pedersen.debug.ProjectedIntercept;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveData;
import pedersen.misc.Host;
import pedersen.misc.Intersects;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.WaveBase;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.grail.WaveAnalysis;

public abstract class CombatWaveBase
extends WaveBase
implements CombatWave {
    protected final WaveAnalysis waveAnalysis;
    protected final Targetable target;
    protected final List firingAngles = new ArrayList();
    protected final WaveData waveData;
    protected boolean isActive = true;
    private static double robotHitBox = 18.0;
    private static final double marginOfError = 18.0 * Math.sqrt(2.0);
    public static long totalFiringAngles = 0L;

    public CombatWaveBase(WaveAnalysis newWaveAnalysis, StaticPosition firingPosition, double bulletVelocity, Targetable newTarget, long timeOfCreation) {
        super(firingPosition, bulletVelocity, timeOfCreation);
        this.waveAnalysis = newWaveAnalysis;
        this.target = newTarget;
        this.waveData = newWaveAnalysis.getWaveData(firingPosition, newTarget, bulletVelocity);
    }

    protected void registerHit() {
        long time = Host.singleton.getTurn();
        double finalBearing = this.getBearing(this.target);
        double bearingOffset = finalBearing - this.waveData.originalBearingToTarget;
        double delta = Math.atan(18.0 / this.getDistance(this.target));
        BearingOffsetRange bearingOffsetRange = new BearingOffsetRange(bearingOffset - delta, bearingOffset + delta, this.getVelocity());
        this.waveData.addBearingOffsetRange(bearingOffsetRange);
        Iterator iterator = this.firingAngles.iterator();
        while (iterator.hasNext()) {
            StaticPositionImpl projectedBulletEndPosition;
            FiringAngle firingAngle = (FiringAngle)iterator.next();
            StaticPositionImpl projectedBulletStartPosition = new StaticPositionImpl((StaticPosition)this, new StaticVectorImpl(firingAngle.getFiringAngle(), this.getRadius(time - 1L)));
            if (!Intersects.doesBulletIntersectRobot(this.target, projectedBulletStartPosition, projectedBulletEndPosition = new StaticPositionImpl((StaticPosition)this, new StaticVectorImpl(firingAngle.getFiringAngle(), this.getRadius(time))))) continue;
            firingAngle.getTargetingStatistics().incrementFired();
            firingAngle.getTargetingStatistics().incrementHit();
            iterator.remove();
        }
    }

    protected void registerMiss() {
        Iterator iterator = this.firingAngles.iterator();
        while (iterator.hasNext()) {
            FiringAngle firingAngle = (FiringAngle)iterator.next();
            firingAngle.getTargetingStatistics().incrementFired();
            iterator.remove();
        }
        this.waveAnalysis.recordWave(this.waveData);
    }

    public boolean isActive(StaticPosition targetPosition, long time) {
        if (this.isActive) {
            if (this.isInRobotHitBox(targetPosition, time)) {
                this.registerHit();
            } else if (this.isOutOfPlay(targetPosition, time)) {
                this.registerMiss();
                this.isActive = false;
            }
        }
        return this.isActive;
    }

    public boolean isHit(StaticPosition robotPosition, long time) {
        boolean isHit = false;
        Iterator iterator = this.firingAngles.iterator();
        while (!isHit && iterator.hasNext()) {
            StaticPositionImpl projectedBulletEndPosition;
            FiringAngle firingAngle = (FiringAngle)iterator.next();
            StaticPositionImpl projectedBulletStartPosition = new StaticPositionImpl((StaticPosition)this, new StaticVectorImpl(firingAngle.getFiringAngle(), this.getRadius(time - 1L)));
            if (!Intersects.doesBulletIntersectRobot(robotPosition, projectedBulletStartPosition, projectedBulletEndPosition = new StaticPositionImpl((StaticPosition)this, new StaticVectorImpl(firingAngle.getFiringAngle(), this.getRadius(time))))) continue;
            isHit = true;
        }
        return isHit;
    }

    private boolean isInRobotHitBox(StaticPosition robot, long time) {
        return Math.abs(this.getRadius(time) - this.getDistance(robot)) < marginOfError;
    }

    protected static boolean isInRobotHitBox(StaticPosition a, StaticPosition b) {
        double deltaX = Math.abs(b.getX() - a.getX());
        double deltaY = Math.abs(b.getY() - a.getY());
        return deltaX < robotHitBox && deltaY < robotHitBox;
    }

    private boolean isOutOfPlay(StaticPosition position, long time) {
        return this.getRadius(time) > this.getDistance(position) + marginOfError;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setInactive() {
        this.isActive = false;
    }

    public void debug() {
    }

    public void onPaint(Graphics2D console) {
        if (this.isLiveRound()) {
            long time = Host.singleton.getTurn();
            console.setColor(Color.cyan);
            GraphicalDebugger.singleton.drawMarker(console, this);
            double radius1 = this.getRadius(time - 1L);
            double radius2 = this.getRadius(time);
            double radius3 = this.getRadius(time + 1L);
            console.setColor(Color.darkGray);
            GraphicalDebugger.singleton.drawRing(console, this, radius1);
            GraphicalDebugger.singleton.drawRing(console, this, radius2);
            GraphicalDebugger.singleton.drawRing(console, this, radius3);
            Iterator firingAngleIterator = this.getFiringAngleIterator();
            while (firingAngleIterator.hasNext()) {
                FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                StaticPositionImpl point1 = new StaticPositionImpl(this, firingAngle.getFiringAngle(), radius1);
                StaticPositionImpl point2 = new StaticPositionImpl(this, firingAngle.getFiringAngle(), radius2);
                StaticPositionImpl point3 = new StaticPositionImpl(this, firingAngle.getFiringAngle(), radius3);
                console.setColor(Color.red);
                GraphicalDebugger.singleton.drawLine(console, point1, point2);
                console.setColor(Color.yellow);
                GraphicalDebugger.singleton.drawLine(console, point2, point3);
                ProjectedIntercept projectedIntercept = firingAngle.getProjectedIntercept();
                if (projectedIntercept == null) continue;
                GraphicalDebugger.singleton.drawProjectedIntercept(console, projectedIntercept);
            }
        }
    }

    public Targetable getTarget() {
        return this.target;
    }

    public void addFiringAngle(FiringAngle firingAngle) {
        this.firingAngles.add(firingAngle);
        ++totalFiringAngles;
    }

    public Iterator getFiringAngleIterator() {
        return this.firingAngles.iterator();
    }

    public WaveAnalysis getWaveAnalysis() {
        return this.waveAnalysis;
    }

    public WaveData getWaveData() {
        return this.waveData;
    }

    public void setLiveRound() {
        this.waveData.setLiveRound();
    }

    public boolean isLiveRound() {
        return this.waveData.isLiveRound();
    }
}

