/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.divination.WaveData;
import pedersen.tactics.bot.BearingOffsetTracker;
import pedersen.tactics.bot.BearingOffsetTrackerBucketMostVisitedImpl;
import pedersen.tactics.bot.BearingOffsetTrackerBucketProbabilityImpl;
import pedersen.tactics.bot.BearingOffsetTrackerRollingAverageImpl;

public class SimpleGFSetup
implements Debuggable {
    private static final int seg1 = 5;
    private static final int seg2 = 5;
    private static final int seg3 = 5;
    private static final int seg4 = 5;
    private final BearingOffsetTracker[][][][] bearingOffsetTrackers = new BearingOffsetTracker[5][5][5][5];

    public SimpleGFSetup initializeAsMostVisited() {
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        this.bearingOffsetTrackers[i][ii][iii][iv] = new BearingOffsetTrackerBucketMostVisitedImpl();
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
        return this;
    }

    public SimpleGFSetup initializeAsProbability() {
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        this.bearingOffsetTrackers[i][ii][iii][iv] = new BearingOffsetTrackerBucketProbabilityImpl();
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
        return this;
    }

    public SimpleGFSetup initializeAsRollingAverage() {
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        this.bearingOffsetTrackers[i][ii][iii][iv] = new BearingOffsetTrackerRollingAverageImpl();
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
        return this;
    }

    public double getBearingOffset(WaveData waveData) {
        int i = SimpleGFSetup.translateVelocityScalarToIndex(waveData.originalLateralVelocity);
        int ii = SimpleGFSetup.translateVelocityToIndex(waveData.originalHeadonVelocity);
        int iii = SimpleGFSetup.translateDistanceToIndex(waveData.originalCwDistanceToWall);
        int iv = SimpleGFSetup.translateDistanceToIndex(waveData.originalCcwDistanceToWall);
        return this.bearingOffsetTrackers[i][ii][iii][iv].getBearingOffset();
    }

    public void addWaveData(WaveData waveData) {
        int i = SimpleGFSetup.translateVelocityScalarToIndex(waveData.originalLateralVelocity);
        int ii = SimpleGFSetup.translateVelocityToIndex(waveData.originalHeadonVelocity);
        int iii = SimpleGFSetup.translateDistanceToIndex(waveData.originalCwDistanceToWall);
        int iv = SimpleGFSetup.translateDistanceToIndex(waveData.originalCcwDistanceToWall);
        this.bearingOffsetTrackers[i][ii][iii][iv].addWaveData(waveData);
    }

    private static int translateVelocityScalarToIndex(double velocityScalar) {
        int index = velocityScalar > 0.75 ? 4 : (velocityScalar > 0.25 ? 3 : (velocityScalar < -0.75 ? 0 : (velocityScalar < -0.25 ? 1 : 2)));
        return index;
    }

    private static int translateVelocityToIndex(double velocity) {
        int index = velocity > 6.0 ? 4 : (velocity > 2.0 ? 3 : (velocity < -6.0 ? 0 : (velocity < -2.0 ? 1 : 2)));
        return index;
    }

    private static int translateDistanceToIndex(double distance) {
        int index = distance < 80.0 ? 0 : (distance < 160.0 ? 1 : (distance < 240.0 ? 2 : (distance < 320.0 ? 3 : 4)));
        return index;
    }

    public void onFire() {
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        this.bearingOffsetTrackers[i][ii][iii][iv].onFire();
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
    }

    public void debug() {
        int i = 0;
        while (i < 5) {
            int ii = 0;
            while (ii < 5) {
                int iii = 0;
                while (iii < 5) {
                    int iv = 0;
                    while (iv < 5) {
                        Debug.debug("this.bearingOffsetTrackers[ " + i + " ][ " + ii + " ][ " + iii + " ][ " + iv + " ]:");
                        this.bearingOffsetTrackers[i][ii][iii][iv].debug();
                        ++iv;
                    }
                    ++iii;
                }
                ++ii;
            }
            ++i;
        }
    }
}

