/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MBotData;
import metal.shared.MMath;
import metal.shared.MPoint;

public class MAimSegment {

    public static class Con {
        private static MPoint enemy;
        public static double time;

        static {
            time = 0.0;
            enemy = null;
        }

        private static void calc(double timeBullet, double flag) {
            double t = timeBullet;
            double s = 8.0 * MMath.sign(MBotData.enemy.speed);
            enemy = enemy.getPoint(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0, s * flag, t);
            time = timeBullet;
        }

        private static void calc(double timeBullet, double factor, double flag) {
            double t = timeBullet;
            double s = 8.0 * MMath.sign(MBotData.enemy.speed);
            enemy = enemy.getPoint(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0, s * flag, t, factor);
            time = timeBullet;
        }

        public static MPoint getLocation(MPoint location, double time, double factor, double flag) {
            enemy = location;
            Con.calc(time, flag);
            return enemy;
        }

        public static MPoint getLocation(MPoint location, double time, double flag) {
            enemy = location;
            Con.calc(time, flag);
            return enemy;
        }
    }

    public static class Des {
        private static MPoint enemy;
        public static double time;

        static {
            time = 0.0;
            enemy = null;
        }

        private static void calc(double speed, double flag) {
            double t = 0.0;
            double s = Math.abs(Math.rint(MBotData.enemy.speed));
            t = s / 2.0;
            s = Des.sumAvg((int)s);
            enemy = MBotData.enemy.getPoint(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0, s * flag * MMath.sign(MBotData.enemy.speed), t);
            time = t;
        }

        public static MPoint getLocation(MPoint location, double speed, double flag) {
            enemy = location;
            Des.calc(speed, flag);
            return enemy;
        }

        private static double sumAvg(int speed) {
            double sum = 0.0;
            int count = 0;
            int i = speed;
            while (i >= 0) {
                sum += (double)i;
                ++count;
                i -= 2;
            }
            return sum / (double)count;
        }
    }

    public static class Acc {
        private static MPoint enemy;
        public static double time;

        static {
            time = 0.0;
            enemy = null;
        }

        private static void calc(double speed, double flag) {
            double t = 0.0;
            double s = Math.abs(Math.rint(MBotData.enemy.speed));
            t = 8.0 - s;
            s = Acc.sumAvg((int)s);
            enemy = enemy.getPoint(MBotData.enemy.heading + MBotData.enemy.headingDiff * 4.0, s * flag * MMath.sign(MBotData.enemy.speed), t);
            time = t;
        }

        public static MPoint getLocation(MPoint location, double speed, double flag) {
            enemy = location;
            Acc.calc(speed, flag);
            return enemy;
        }

        private static double sumAvg(int speed) {
            double sum = 0.0;
            int i = speed;
            while (i == 8) {
                sum += (double)i;
                ++i;
            }
            return sum / (double)(8 - (speed == 8 ? 0 : speed));
        }
    }
}

