/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Random;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MChromosoom;
import metal.shared.MDna;
import metal.shared.MMath;
import metal.shared.MPoint;
import robocode.HitByBulletEvent;

public class MChassisDna5b {
    static double MIN_DIST;
    public TreeMap bullets = new TreeMap();
    static int c;
    private static MPoint centre;
    static double coolTime;
    static double dir;
    static MDna[] dnas;
    private static MPoint enemyPoint;
    private static double firePower;
    private static double fireTime;
    static boolean first;
    static int i;
    private static MPoint nextPoint;
    private static Random rand;
    static double speed;
    static int speedCounter;

    static {
        rand = new Random();
        centre = null;
        nextPoint = null;
        enemyPoint = null;
        firePower = 0.0;
        fireTime = 0.0;
        dnas = new MDna[50];
        i = 0;
        first = true;
        c = 0;
        speedCounter = 0;
        MIN_DIST = 60.0;
        dir = 1.0;
        coolTime = 0.0;
        speed = 0.0;
    }

    public MChassisDna5b() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
        centre = new MPoint(MBotData.self.getBattleFieldWidth() / 2.0, MBotData.self.getBattleFieldHeight() / 2.0);
        if (first) {
            MChassisDna5b.init();
            first = false;
        }
    }

    public static void go(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-1.0, 1.0));
        MBotData.self.setAhead(dist);
    }

    private static void init() {
        int i = 0;
        while (i < dnas.length) {
            MChassisDna5b.dnas[i] = new MDna();
            ++i;
        }
    }

    private static void initDNA() {
        int i = 0;
        while (i < dnas.length) {
            dnas[i].mergeDna(dnas[i].furtilize());
            ++i;
        }
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        if (MBotData.enemy.distance > 350.0) {
            MChassisDna5b.go(MPoint.validate(new MPoint(MBotData.enemy.x / 2.0, MBotData.enemy.y / 2.0)));
        } else {
            MChassisDna5b.go(MBotData.enemy);
        }
    }

    public static void move() {
        try {
            MChassisDna5b.movement();
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        double L = 0.0;
        double angle = 0.0;
        double distAngle = 0.0;
        double moveAngle = 0.0;
        double distance = MBotData.enemy.last.last.last.distance;
        boolean isCentered = false;
        boolean isVerticle = false;
        int index = 10;
        if (MBotData.enemy.isFired) {
            MBotData.enemy.isFired = false;
            firePower = MBotData.enemy.energyDiff;
            fireTime = MBotData.enemy.time;
            coolTime = MBotData.self.getTime() - 1L + (long)(Math.random() < 0.4 ? 0 : 4) + (long)((1.0 + firePower / 5.0) / MBotData.self.getGunCoolingRate()) - 1L;
            index = (int)MMath.clamp(30.0, 0.0, distance / (MBullet.getSpeed(firePower) / 10.0));
            speed = MMath.sign(Math.random() < 0.73 ? -1 : 1);
            if (MMath.abs(MBotData.enemy.energyDiff) < 0.9) {
                speed = 1.0;
            }
        }
        if (MMath.abs(MBotData.self.getDistanceRemaining()) > MIN_DIST && MMath.abs(MBotData.self.getDistanceRemaining()) < MIN_DIST + 21.0) {
            MBotData.self.setMaxVelocity(0.0);
        }
        if (MMath.abs(MBotData.self.getDistanceRemaining()) < MIN_DIST || MMath.abs(MBotData.self.getDistanceRemaining()) > 250.0) {
            if (MMath.abs(MBotData.enemy.energyDiff - 1.55) < 1.46 || MBotData.enemy.distance < 200.0) {
                angle = MMath.abs((MBotData.enemy.bearing + 360.0) % 90.0);
                isCentered = MBotData.getLocation().distance(centre) < centre.distance(0.0, 0.0) / 2.0;
                isVerticle = angle < 22.5 || angle > 157.5 || isCentered;
                distAngle = 2.0 * Math.toDegrees(Math.asin(4.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                if (isVerticle) {
                    distAngle = Math.toDegrees(Math.asin(8.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                }
                MChromosoom crom = dnas[index].getFittest();
                double tola = crom.value == 0.0 ? 2.0 : crom.value * crom.dir * dir;
                MIN_DIST = 50.0 + crom.value / 3.0;
                distAngle = MMath.atan(MMath.tan(distAngle) + (MIN_DIST / 2.0 - 4.0) / distance);
                if (distance < 200.0) {
                    // empty if block
                }
                distance += 30.0;
                do {
                    moveAngle += distAngle * MMath.random(crom.min, crom.max);
                    L = distance;
                    if (isVerticle) {
                        L /= MMath.cos(moveAngle);
                    }
                    distance -= 10.0;
                    nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + moveAngle, -L);
                } while (MPoint.getWallDistance(nextPoint) < 30.0);
                if (++i == 0) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness -= 2;
                    dnas[index].mutate(i + "");
                } else if (i == -1) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 1.5);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 1.9);
                    dnas[index].mutate(i + "");
                } else if (i == 1) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 1.99);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 1.6);
                    dnas[index].mutate(i + "");
                } else if (i == -2) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 3.9);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 2.9);
                    dnas[index].mutate(i + "");
                } else if (i == 2) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 3.94);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 1.74);
                    dnas[index].mutate(i + "");
                } else if (i == -3) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 1.9);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 2.7);
                    dnas[index].mutate(i + "");
                } else if (i == 3) {
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5b.i).append((String)"").toString()).fitness - 2.5);
                    MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)(-MChassisDna5b.i)).append((String)"").toString()).fitness - 1.2);
                    dnas[index].mutate(i + "");
                }
                dir = MMath.sign(crom.max);
                ++MChassisDna5b.dnas[index].counter;
                ++c;
                MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? -1.0 : 8.0);
            } else if (MBotData.self.getDistanceRemaining() == 0.0) {
                nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + Math.toDegrees(Math.random() * 0.04 - 0.02), -MBotData.enemy.distance);
                MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? -2.0 : 8.0);
                ++i;
            }
            if (nextPoint != null) {
                MChassisDna5b.go(nextPoint);
            }
        }
        MBotData.self.setMaxVelocity(8.0);
        if ((double)MBotData.self.getTime() >= coolTime - 4.0 && coolTime <= (double)MBotData.self.getTime() && MBotData.enemy.distance > 150.0 && speed < 0.0) {
            MBotData.self.setMaxVelocity(0.0);
            nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + Math.toDegrees(Math.random() * 0.04 - 0.02), -MBotData.enemy.distance);
            MChassisDna5b.go(nextPoint);
        } else {
            MBotData.self.setMaxVelocity(9.0);
        }
        ++speedCounter;
    }

    public void update(HitByBulletEvent e) {
        try {
            MBulletEnemy b = (MBulletEnemy)MBotData.enemy.bullets.get((e.getVelocity() + "00000").substring(0, 6));
            double dist = b.getDistance();
            double bearing = -e.getBearing();
            int index = (int)MMath.clamp(30.0, 0.0, dist / e.getVelocity() / 10.0);
            int i = (int)Math.rint(bearing / 40.0) % 4;
            double d = b.power = b.power < 1.0 ? 1.0 : b.power;
            if (i == 0) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (1.0 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == -1) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (1.5 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == 1) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (2.0 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == -2) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (1.9 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == 2) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (2.5 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == -3) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (2.3 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            } else if (i == 3) {
                MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - (2.7 + (double)MChassisDna5b.dnas[index].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 100.0));
            }
            dnas[index].mutate(i + "");
            MBotData.enemy.bullets.remove(b.toString());
        }
        catch (Exception ex) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED TIME: " + MBotData.self.getTime());
            MBotData.err("SYSTEM:   Err: No bullets matched! " + (e.getVelocity() + "00000").substring(0, 6) + " " + ex.toString());
        }
    }
}

