/*
 * Decompiled with CFR 0.152.
 */
package metal.small.dna2;

import java.awt.Color;
import metal.shared.MBotData;
import metal.shared.MChassisDna5;
import metal.shared.MEnemy;
import metal.shared.MGun;
import metal.shared.MGun1;
import metal.shared.MRadar;
import metal.shared.MScorer;
import metal.small.dna2.MGunB;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class MCoolDNA
extends MBotData {
    MGunB bee;
    MChassisDna5 chassis;

    static {
        MBotData.print("SYSTEM: New MCool 1.3 bot...");
        MBotData.enemy = new MEnemy();
        MBotData.scorer = new MScorer();
    }

    private void init() {
        MBotData.print("\nSYSTEM: Initialising...");
        super.setColors(Color.blue.darker(), Color.gray.brighter(), Color.red);
        super.setAdjustGunForRobotTurn(true);
        super.setAdjustRadarForGunTurn(true);
        super.setEventPriority("HitByBulletEvent", 50);
        MBotData.self = this;
        MBotData.scanner = new MRadar();
        MBotData.gun = new MGun();
        MBotData.gun1 = new MGun1();
        MBotData.enemy.init();
        this.chassis = new MChassisDna5();
    }

    public void onBulletHit(BulletHitEvent e) {
        this.bee.onBulletHit(e);
        MBotData.scorer.update(e);
        MBotData.enemy.isFired = false;
    }

    public void onDeath(DeathEvent e) {
        MBotData.print("SYSTEM: Ending ...\n");
        MBotData.scorer.score();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.chassis.update(e);
        MBotData.scorer.update(e);
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        MRadar.update(e);
        this.bee.onScannedRobot(e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++MScorer.skip;
    }

    public void onWin(WinEvent e) {
        MScorer.win += 1.0;
        MBotData.print("SYSTEM: Ending ...\n");
        MBotData.scorer.score();
    }

    public void run() {
        this.init();
        this.bee = new MGunB(this);
        MBotData.print("\nSYSTEM: Running ...");
        this.turnRadarRight(360.0);
        MBotData.enemy.timeZero = this.getTime();
        while (true) {
            MCoolDNA mCoolDNA = this;
            mCoolDNA.chassis.move();
            MBotData.scanner.scan();
            this.execute();
        }
    }
}

