/*
 * Decompiled with CFR 0.152.
 */
package metal.small.dna2;

import java.awt.geom.Point2D;
import java.util.List;
import metal.small.dna2.PUtils;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

public abstract class Wave
extends Condition {
    private double bearingDirection;
    private double bulletVelocity;
    private double distanceFromGun;
    private Point2D gunLocation;
    private int middleBin;
    private int numBins;
    protected static AdvancedRobot robot;
    private double startBearing;
    private Point2D targetLocation;

    public void advance(int ticks) {
        this.distanceFromGun += (double)ticks * this.bulletVelocity;
    }

    public int botWidth() {
        return (int)Math.ceil((double)this.middleBin * (Math.atan2(36.0, this.getFireDistance()) / this.maxEscapeAngle()));
    }

    public double distance(Point2D location) {
        return this.distance(location, 0);
    }

    public double distance(int timeOffset) {
        return this.distance(this.targetLocation, timeOffset);
    }

    public double distance(Point2D location, int timeOffset) {
        return this.gunLocation.distance(location) - this.distanceFromGun - (double)timeOffset * this.bulletVelocity;
    }

    public static Wave findClosest(List waves, Point2D location, double velocity) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Wave closest = null;
        int i = 0;
        int n = waves.size();
        while (i < n) {
            Wave wave = (Wave)((Object)waves.get(i));
            double d = Math.abs(wave.distance(location));
            if (d < closestDistance && (velocity < 0.0 || Math.abs(wave.bulletVelocity - velocity) < 0.01)) {
                closest = wave;
                closestDistance = d;
            }
            ++i;
        }
        return closest;
    }

    public static Wave findClosest(List waves, Point2D location) {
        return Wave.findClosest(waves, location, -1.0);
    }

    public double getBulletVelocity() {
        return this.bulletVelocity;
    }

    public double getFireDistance() {
        return this.gunLocation.distance(this.targetLocation);
    }

    public Point2D getGunLocation() {
        return this.gunLocation;
    }

    public AdvancedRobot getRobot() {
        return robot;
    }

    public double gunBearing(Point2D target) {
        return PUtils.absoluteBearing(this.gunLocation, target);
    }

    public void init(AdvancedRobot robot, int numBins) {
        Wave.robot = robot;
        this.numBins = numBins;
        this.middleBin = (numBins - 1) / 2;
    }

    public double maxEscapeAngle() {
        return PUtils.maxEscapeAngle(this.bulletVelocity);
    }

    public boolean passed(double distanceOffset) {
        return this.distanceFromGun > this.gunLocation.distance(this.targetLocation) + distanceOffset;
    }

    public void setBearingDirection(double bearingDirection) {
        this.bearingDirection = bearingDirection;
    }

    public void setBulletVelocity(double bulletVelocity) {
        this.bulletVelocity = bulletVelocity;
    }

    public void setGunLocation(Point2D gunLocation) {
        this.gunLocation = gunLocation;
    }

    public void setStartBearing(double startBearing) {
        this.startBearing = startBearing;
    }

    public void setTargetLocation(Point2D targetLocation) {
        this.targetLocation = targetLocation;
    }

    public abstract boolean test();

    public double travelTime(double distance) {
        return distance / this.bulletVelocity;
    }

    public int visitingIndex(double bearing) {
        return (int)PUtils.minMax(Math.round(Utils.normalRelativeAngle((double)(bearing - this.startBearing)) / this.bearingDirection + (double)this.middleBin), 1.0, this.numBins - 1);
    }

    public int visitingIndex(Point2D location) {
        return this.visitingIndex(PUtils.absoluteBearing(this.gunLocation, location));
    }

    public int visitingIndex() {
        return this.visitingIndex(this.targetLocation);
    }
}

