/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.AbstractStrategy;
import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.Enemy;
import amarok.FireSolution;
import amarok.Strategy;
import robocode.AdvancedRobot;

public class WallsPrediction
extends AbstractStrategy
implements Strategy,
BotConstants {
    public double getGoodness() {
        return 0.1;
    }

    public void doOneTurn() {
        Enemy nme = this.arena.getEnemy();
        if (nme == null) {
            return;
        }
        double x = nme.getPoint().x;
        double y = nme.getPoint().y;
        double velocity = nme.getVelocity();
        double heading = nme.getHeading();
        AdvancedRobot me = this.arena.getMe();
        long now = me.getTime();
        double X = me.getX();
        double Y = me.getY();
        double x1 = 0.0;
        double y1 = 0.0;
        double botDistance = 0.0;
        double firingDistance = 0.0;
        long dt = 0L;
        int deltaHeat = (int)(me.getGunHeat() / me.getGunCoolingRate());
        if (deltaHeat > 5) {
            return;
        }
        long i = now + (long)deltaHeat;
        while (i < now + 50L) {
            if ((firingDistance = 15.5 * (double)(++dt)) > (botDistance = BotMath.getDistance(x1 = x + velocity * (double)dt * Math.sin(heading), y1 = y + velocity * (double)dt * Math.cos(heading), X, Y))) {
                FireSolution fireSolution = this.arena.getFireSolution();
                fireSolution.setCalculatedGunHeading(BotMath.getAlpha(x1, y1, X, Y));
                double vb = botDistance / (double)dt;
                fireSolution.setCalculatedGunPower((20.0 - vb) / 3.0);
                fireSolution.setCalculatedFiringTime(i - dt);
                fireSolution.setSolved(true);
                return;
            }
            ++i;
        }
    }

    public String toString() {
        return "WallsPrediction";
    }

    public WallsPrediction(Arena a) {
        super(a);
    }
}

