/*
 * Decompiled with CFR 0.152.
 */
package av;

import java.awt.Color;
import java.util.Collections;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobAtHome
extends AdvancedRobot {
    LinkedList<EnemyBot> enemyList;

    EnemyBot searchList(LinkedList<EnemyBot> l, String name) {
        for (EnemyBot b : l) {
            if (b.e.getName() != name) continue;
            return b;
        }
        return null;
    }

    void showList(LinkedList<EnemyBot> l) {
        int nr = 0;
        for (EnemyBot b : l) {
            this.out.println(String.valueOf(++nr) + ". " + b.e.getName() + " : " + b.distance);
        }
    }

    void aim(EnemyBot b) {
        double target_bearing = 90.0 - Math.atan2(b.aim_y - this.getY(), b.aim_x - this.getX()) * 180.0 / Math.PI - this.getHeading();
        double turn = target_bearing - (this.getGunHeading() - this.getHeading());
        if (turn > 180.0) {
            turn -= 360.0;
        }
        if (turn < -180.0) {
            turn += 360.0;
        }
        this.setTurnGunRight(turn);
    }

    void move() {
        double move_x = 400.0;
        double move_y = 300.0;
        double move_bearing = 90.0 - Math.atan2(move_y - this.getY(), move_x - this.getX()) * 180.0 / Math.PI;
        double turn = move_bearing - this.getHeading();
        if (turn > 180.0) {
            turn -= 360.0;
        }
        if (turn < -180.0) {
            turn += 360.0;
        }
        this.setTurnRight(turn);
        if (Math.random() > 0.5) {
            this.setAhead(30.0);
        }
    }

    public void run() {
        this.setColors(Color.black, Color.red, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.enemyList = new LinkedList();
        while (true) {
            this.setTurnRadarRight(360.0);
            this.move();
            if (!this.enemyList.isEmpty()) {
                this.aim(this.enemyList.getFirst());
                if (Math.abs(this.getGunTurnRemaining()) < 1.0) {
                    this.setFire(this.enemyList.getFirst().firePower);
                }
            }
            this.execute();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        EnemyBot bot = this.searchList(this.enemyList, e.getName());
        if (bot != null) {
            this.enemyList.remove(bot);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyBot bot = this.searchList(this.enemyList, e.getName());
        if (bot != null) {
            this.enemyList.remove(bot);
        }
        EnemyBot newBot = new EnemyBot(e);
        newBot.distance = e.getDistance();
        newBot.firePower = 2.0;
        double bulletspeed = 20.0 - 3.0 * newBot.firePower;
        newBot.aim_x = Math.cos((90.0 - e.getBearing() - this.getHeading()) * Math.PI / 180.0) * e.getDistance() + Math.cos((90.0 - e.getHeading()) * Math.PI / 180.0) * e.getVelocity() * e.getDistance() / bulletspeed + this.getX();
        newBot.aim_y = Math.sin((90.0 - e.getBearing() - this.getHeading()) * Math.PI / 180.0) * e.getDistance() + Math.sin((90.0 - e.getHeading()) * Math.PI / 180.0) * e.getVelocity() * e.getDistance() / bulletspeed + this.getY();
        this.enemyList.add(newBot);
        Collections.sort(this.enemyList);
        this.showList(this.enemyList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EnemyBot
    implements Comparable<EnemyBot> {
        ScannedRobotEvent e;
        double cur_x;
        double cur_y;
        double vel_x;
        double vel_y;
        double aim_x;
        double aim_y;
        double distance;
        double firePower;

        EnemyBot(ScannedRobotEvent e) {
            this.e = e;
        }

        @Override
        public int compareTo(EnemyBot b) {
            if (this.distance < b.distance) {
                return -1;
            }
            if (this.distance == b.distance) {
                return 0;
            }
            return 1;
        }
    }
}

