/*
 * Decompiled with CFR 0.152.
 */
package cb;

import cb.ml.BaselineMovement;
import cb.ml.DomogledTargeting;
import cb.ml.Features;
import cb.ml.Movement;
import cb.ml.Observation;
import cb.ml.ObservationType;
import cb.ml.Targeting;
import cb.util.BattleFieldUtils;
import cb.util.BulletWave;
import cb.util.DataStorage;
import cb.util.MovementCommands;
import cb.util.MovementState;
import cb.util.Shadow;
import cb.util.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class Domogled
extends AdvancedRobot {
    private static final boolean WRITE_DATA = true;
    private static boolean initialized = false;
    private static BattleFieldUtils battleField;
    private static double myBulletPowerFired;
    private static double myBulletPowerHit;
    private static String opponentName;
    private static Targeting targeting;
    private static Movement movement;
    private static ArrayList<Observation> targetingObservations;
    private static ArrayList<Observation> movementObservations;
    private long time;
    private int circleDirection = 1;
    private MovementState myNextState;
    private MovementState myState;
    private MovementState myOldState;
    private MovementState myOld2State;
    private MovementState myOld3State;
    private double myEnergy;
    private double myBulletPower;
    private MovementState opponentState;
    private long opponentTimeSinceLastDeceleration = 0L;
    private double opponentEnergy = 100.0;
    private double opponentBulletPower = 2.0;
    private Point2D.Double destination = new Point2D.Double();
    private Point2D.Double target = new Point2D.Double();
    private ArrayList<Wave> waves = new ArrayList();
    private ArrayList<Point2D.Double> possibleDestinations = new ArrayList();
    private ArrayList<BulletWave> bulletWaves = new ArrayList();

    private void initializeBot() {
        this.setColors(new Color(83, 250, 225), new Color(20, 62, 200), new Color(0, 162, 200));
        battleField = new BattleFieldUtils();
        battleField.setDimensions(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        initialized = true;
    }

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.radar();
            this.movement();
            this.gun();
            this.execute();
        }
    }

    private void radar() {
        if (this.opponentState == null) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        } else {
            double angle = BattleFieldUtils.absoluteBearing(this.myState.location, this.opponentState.location);
            double maxDistance = (this.myState.time - this.opponentState.time) * 8L;
            double extraTurn = Math.atan(maxDistance / this.myState.location.distance(this.opponentState.location));
            if (Utils.normalRelativeAngle((double)(angle - this.getRadarHeadingRadians())) < 0.0) {
                this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(angle - extraTurn - this.getRadarHeadingRadians())));
            } else {
                this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(angle + extraTurn - this.getRadarHeadingRadians())));
            }
        }
    }

    private void movement() {
        this.possibleDestinations.clear();
        this.waves.sort((w1, w2) -> {
            if (w1.getTimeUntilHit(this.myState.location, this.time) > w2.getTimeUntilHit(this.myState.location, this.time)) {
                return 1;
            }
            return -1;
        });
        if (this.waves.size() > 0 && this.opponentState != null) {
            Wave firstWave = this.waves.get(0);
            double lowestDanger = Double.POSITIVE_INFINITY;
            for (int direction = -1; direction <= 1; direction += 2) {
                MovementState state = battleField.predictPosition(direction, this.myState, this.opponentState.location, firstWave.getSource(), firstWave.getTime(), firstWave.getEnemyBulletPower(), this.getDesiredDistance(), 8.0);
                this.possibleDestinations.add(state.location);
                double danger = firstWave.getEnemyBulletPower() * firstWave.getDanger(state.location, movement);
                if (this.waves.size() > 1) {
                    Wave secondWave = this.waves.get(1);
                    double minSecondDanger = secondWave.getEnemyBulletPower() * secondWave.getDanger(state.location, movement);
                    if (this.waves.size() > 2) {
                        minSecondDanger += 0.5 * this.waves.get(2).getEnemyBulletPower() * this.waves.get(2).getDanger(state.location, movement);
                    }
                    for (int d2 = -1; d2 <= 1; d2 += 2) {
                        MovementState secondState = battleField.predictPosition(d2, state, this.opponentState.location, secondWave.getSource(), secondWave.getTime(), secondWave.getEnemyBulletPower(), this.getDesiredDistance(), 8.0);
                        double d = secondWave.getEnemyBulletPower() * secondWave.getDanger(secondState.location, movement);
                        if (this.waves.size() > 2) {
                            d += 0.5 * this.waves.get(2).getEnemyBulletPower() * this.waves.get(2).getDanger(state.location, movement);
                        }
                        minSecondDanger = Math.min(minSecondDanger, d);
                    }
                    danger += minSecondDanger;
                }
                if (!(danger < lowestDanger)) continue;
                lowestDanger = danger;
                this.circleDirection = direction;
            }
            if (this.myState.location.distance(this.opponentState.location) < 150.0) {
                Point2D.Double destination = battleField.circle(this.myState.location, this.circleDirection, this.opponentState.location, this.getDesiredDistance(), this.opponentBulletPower);
                Point2D.Double destination2 = battleField.circle(this.myState.location, -this.circleDirection, this.opponentState.location, this.getDesiredDistance(), this.opponentBulletPower);
                if (this.opponentState.location.distance(destination) < this.myState.location.distance(destination) && this.opponentState.location.distance(destination2) > this.myState.location.distance(destination2)) {
                    this.circleDirection = -this.circleDirection;
                }
            }
            this.destination = battleField.circle(this.myState.location, this.circleDirection, this.opponentState.location, this.getDesiredDistance(), this.opponentBulletPower);
        } else if (this.opponentState != null) {
            this.destination = battleField.circle(this.myState.location, this.circleDirection, this.opponentState.location, this.getDesiredDistance(), this.opponentBulletPower);
            Point2D.Double b = battleField.circle(this.myState.location, -this.circleDirection, this.opponentState.location, this.getDesiredDistance(), this.opponentBulletPower);
            if (this.opponentState.location.distance(this.destination) < this.myState.location.distance(this.destination) && this.opponentState.location.distance(b) > this.myState.location.distance(b)) {
                this.circleDirection = -this.circleDirection;
                this.destination = b;
            }
        } else {
            this.destination.setLocation(this.myState.location.x, this.myState.location.y);
        }
        MovementCommands commands = battleField.goTo(this.myState, this.destination);
        this.myNextState = this.myState.predict(commands);
        this.setTurnRightRadians(commands.getTurnAngle());
        this.setMaxVelocity(commands.getMaxVelocity());
        this.setAhead(commands.getDistance());
    }

    private double getDesiredDistance() {
        return BattleFieldUtils.limit(350.0, this.myState.location.distance(this.opponentState.location) + 80.0, 1000.0);
    }

    private void gun() {
        if (this.opponentState != null) {
            Bullet bullet;
            this.calculateBulletPower();
            double currentGuessFactor = 0.0;
            double smallestDiff = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.bulletWaves.size(); ++i) {
                BulletWave bulletWave = this.bulletWaves.get(i);
                double diff = bulletWave.getDiffUntilHit(this.opponentState.location, this.time);
                if (diff < 0.0) {
                    this.addTargetingData(bulletWave.getFeatures(), bulletWave.getGuessFactor(this.opponentState.location), ObservationType.MISS);
                    this.bulletWaves.remove(i);
                    --i;
                    continue;
                }
                if (!(diff < smallestDiff)) continue;
                smallestDiff = diff;
                currentGuessFactor = bulletWave.getGuessFactor(this.opponentState.location);
            }
            BulletWave newBulletWave = new BulletWave(this.myState, this.opponentState, this.opponentTimeSinceLastDeceleration, this.myBulletPower, currentGuessFactor, battleField);
            this.target = newBulletWave.getPoint(targeting.aim(newBulletWave.getFeatures()));
            double targetAngle = BattleFieldUtils.absoluteBearing(this.myNextState.location, this.target);
            double angleTolerance = Math.atan(14.0 / this.myState.location.distance(this.target));
            double randomOffset = (0.5 - Math.random()) * Math.atan(3.0 / this.myState.location.distance(this.target));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetAngle + randomOffset - this.getGunHeadingRadians())));
            if (this.myEnergy > 0.101 && Math.abs(this.getGunTurnRemainingRadians()) < angleTolerance && (bullet = this.setFireBullet(this.myBulletPower)) != null) {
                myBulletPowerFired += this.myBulletPower;
                newBulletWave.setBullet(bullet);
                this.bulletWaves.add(newBulletWave);
            }
        }
    }

    private void calculateBulletPower() {
        double distance = this.myState.location.distance(this.opponentState.location);
        if (distance < 140.0) {
            this.myBulletPower = this.myEnergy;
        } else {
            this.myBulletPower = 1.99;
            double myHitRate = myBulletPowerHit / myBulletPowerFired;
            if (myBulletPowerFired > 20.0 && myHitRate > 0.25) {
                this.myBulletPower = 2.49;
                if (myHitRate > 0.33) {
                    this.myBulletPower = 2.99;
                }
            }
            if (distance > 325.0 && this.myEnergy < 63.0) {
                if (distance > 600.0 && (this.myEnergy < 20.0 || this.myEnergy - 10.0 < this.opponentEnergy)) {
                    this.myBulletPower = 0.1;
                } else {
                    double powerDownPoint = BattleFieldUtils.limit(35.0, 63.0 + 4.0 * (this.opponentEnergy - this.myEnergy), 63.0);
                    if (this.myEnergy < powerDownPoint) {
                        double v = this.myEnergy / powerDownPoint;
                        this.myBulletPower = Math.min(this.myBulletPower, v * v * v * 1.99);
                    }
                    if (this.myEnergy - 25.0 < this.opponentEnergy) {
                        this.myBulletPower = Math.min(this.myBulletPower, this.opponentBulletPower * 0.9);
                    }
                }
            }
            this.myBulletPower = Math.min(this.myBulletPower, this.opponentEnergy / 4.0);
            this.myBulletPower = Math.min(this.myBulletPower, this.myEnergy);
        }
        this.myBulletPower = BattleFieldUtils.limit(0.1, this.myBulletPower, 2.999);
    }

    public final void onStatus(StatusEvent e) {
        int i;
        if (!initialized) {
            this.initializeBot();
        }
        this.time = e.getTime();
        this.myEnergy = e.getStatus().getEnergy();
        this.myOld3State = this.myOld2State;
        this.myOld2State = this.myOldState;
        this.myOldState = this.myState;
        this.myState = new MovementState(this.time, new Point2D.Double(e.getStatus().getX(), e.getStatus().getY()), e.getStatus().getHeadingRadians(), e.getStatus().getVelocity());
        for (i = 0; i < this.waves.size(); ++i) {
            Wave wave = this.waves.get(i);
            if (!wave.hasPassed(this.myState.location, this.time)) continue;
            this.addMovementData(wave.getFeatures(), wave.getGuessFactor(this.myState.location), ObservationType.MISS);
            this.waves.remove(i);
            --i;
        }
        for (i = 0; i < this.bulletWaves.size(); ++i) {
            BulletWave bulletWave = this.bulletWaves.get(i);
            Point2D.Double p1 = bulletWave.getLocation(this.time);
            if (!battleField.contains(p1, 0.0)) {
                this.bulletWaves.remove(i);
                --i;
                continue;
            }
            for (Wave wave : this.waves) {
                double distance1 = wave.getDistanceTraveled(this.time);
                if (!(wave.getSource().distance(p1) < distance1)) continue;
                Point2D.Double p2 = bulletWave.getLocation(this.time - 1L);
                double distance2 = wave.getDistanceTraveled(this.time - 1L);
                if (!(wave.getSource().distance(p2) > distance2)) continue;
                wave.addShadow(p1, p2);
            }
        }
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        opponentName = e.getName();
        Point2D.Double location = BattleFieldUtils.project(this.myState.location, e.getBearingRadians() + this.myState.heading, e.getDistance());
        double energyLoss = this.opponentEnergy - e.getEnergy();
        if (energyLoss > 0.099 && energyLoss < 3.01) {
            this.opponentBulletPower = energyLoss;
            Wave wave = new Wave(this.opponentState, energyLoss, this.myOld2State, this.myOld3State);
            this.waves.add(wave);
        }
        this.opponentEnergy = e.getEnergy();
        this.opponentTimeSinceLastDeceleration = this.opponentState != null && Math.abs(e.getVelocity()) < Math.abs(this.opponentState.velocity) ? 0L : ++this.opponentTimeSinceLastDeceleration;
        this.opponentState = new MovementState(this.time, location, e.getHeadingRadians(), e.getVelocity());
    }

    public void onBulletHit(BulletHitEvent e) {
        myBulletPowerHit += e.getBullet().getPower();
        this.opponentEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
        Point2D.Double p = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        for (int k = 0; k < this.bulletWaves.size(); ++k) {
            BulletWave bulletWave = this.bulletWaves.get(k);
            if (!(Math.abs(bulletWave.getMyBulletPower() - e.getBullet().getPower()) < 0.01) || !(p.distance(bulletWave.getLocation(e.getTime())) < 50.0)) continue;
            this.addTargetingData(bulletWave.getFeatures(), bulletWave.getGuessFactor(p), ObservationType.HIT);
            this.bulletWaves.remove(k);
            --k;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.opponentEnergy += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        Point2D.Double p = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        for (int k = 0; k < this.waves.size(); ++k) {
            Wave wave = this.waves.get(k);
            if (!(Math.abs(e.getPower() - wave.getEnemyBulletPower()) < 0.01) || !(Math.abs(wave.getTimeUntilHit(this.myState.location, e.getTime())) < 2.5)) continue;
            this.addMovementData(wave.getFeatures(), wave.getGuessFactor(p), ObservationType.HIT);
            this.waves.remove(k);
            return;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        int k;
        Point2D.Double p = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
        for (k = 0; k < this.waves.size(); ++k) {
            Wave wave = this.waves.get(k);
            if (!(Math.abs(e.getHitBullet().getPower() - wave.getEnemyBulletPower()) < 0.01) || !(Math.abs(wave.getTimeUntilHit(p, e.getTime())) < 2.5)) continue;
            this.addMovementData(wave.getFeatures(), wave.getGuessFactor(p), ObservationType.BULLETHITBULLET);
            this.waves.remove(k);
            --k;
        }
        p = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        for (k = 0; k < this.bulletWaves.size(); ++k) {
            BulletWave bulletWave = this.bulletWaves.get(k);
            if (!(Math.abs(bulletWave.getMyBulletPower() - e.getBullet().getPower()) < 0.01) || !(p.distance(bulletWave.getLocation(e.getTime())) < 50.0)) continue;
            this.addTargetingData(bulletWave.getFeatures(), bulletWave.getGuessFactor(p), ObservationType.BULLETHITBULLET);
            this.bulletWaves.remove(k);
            --k;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.opponentState = null;
    }

    public void onRoundEnded(RoundEndedEvent e) {
        System.out.println("Weighted total hit rate: " + (double)Math.round(1000.0 * myBulletPowerHit / myBulletPowerFired) / 10.0 + "%");
    }

    public void onBattleEnded(BattleEndedEvent e) {
        if (opponentName == null) {
            System.out.println("Not writing any data.");
        } else {
            try {
                DataStorage.writeCSV(this.getDataFile("movement_" + opponentName + ".csv"), movementObservations);
                DataStorage.writeCSV(this.getDataFile("targeting_" + opponentName + ".csv"), targetingObservations);
            }
            catch (IOException e1) {
                System.out.println("Could not write csv file.");
            }
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.BLUE);
        if (this.myState != null) {
            g.drawRect((int)this.myState.location.x - 18, (int)this.myState.location.y - 18, 36, 36);
        }
        g.setColor(Color.RED);
        if (this.opponentState != null) {
            g.drawRect((int)this.opponentState.location.x - 18, (int)this.opponentState.location.y - 18, 36, 36);
        }
        g.setColor(Color.ORANGE);
        for (Point2D.Double point : this.possibleDestinations) {
            g.fillOval((int)point.getX() - 3, (int)point.getY() - 3, 6, 6);
        }
        g.setColor(Color.GREEN);
        if (this.destination != null) {
            g.fillOval((int)this.destination.getX() - 3, (int)this.destination.getY() - 3, 6, 6);
        }
        g.setColor(Color.DARK_GRAY);
        for (Wave wave : this.waves) {
            double r = (double)(this.time - wave.getTime()) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower());
            double x = wave.getSource().x - r;
            double y = wave.getSource().y - r;
            g.drawOval((int)x, (int)y, (int)(2.0 * r), (int)(2.0 * r));
            Point2D.Double t = BattleFieldUtils.project(wave.getSource(), wave.getAngle(), r);
            g.drawLine((int)wave.getSource().x, (int)wave.getSource().y, (int)t.x, (int)t.y);
        }
        g.setColor(Color.ORANGE);
        for (BulletWave bulletWave : this.bulletWaves) {
            Point2D.Double p1 = bulletWave.getLocation(this.time);
            Point2D.Double p2 = bulletWave.getLocation(this.time - 1L);
            g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
        }
        for (Wave wave : this.waves) {
            double danger;
            Point2D.Double p;
            double gf;
            double minDanger = Double.POSITIVE_INFINITY;
            double maxDanger = Double.NEGATIVE_INFINITY;
            double step = 0.1;
            for (gf = -1.0; gf <= 1.0; gf += step) {
                p = BattleFieldUtils.project(wave.getSource(), wave.getAngle(gf), (double)(this.time - wave.getTime() - 1L) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                danger = wave.getDanger(p, movement);
                minDanger = Math.min(minDanger, danger);
                maxDanger = Math.max(maxDanger, danger);
            }
            for (gf = -1.0; gf <= 1.0; gf += step) {
                p = BattleFieldUtils.project(wave.getSource(), wave.getAngle(gf), (double)(this.time - wave.getTime() - 1L) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                danger = wave.getDanger(p, movement);
                if (danger == 0.0) {
                    g.setColor(Color.BLUE);
                } else {
                    double factor = (danger - minDanger) / (maxDanger - minDanger);
                    double t = 0.2;
                    if (factor > t) {
                        factor = (factor - t) / (1.0 - t);
                        g.setColor(new Color(255, (int)(255.0 * (1.0 - factor)), 0));
                    } else {
                        g.setColor(new Color((int)((factor /= t) * 255.0), 255, 0));
                    }
                }
                Point2D.Double p1 = BattleFieldUtils.project(wave.getSource(), wave.getAngle(gf), (double)(this.time - wave.getTime() - 1L) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                Point2D.Double p2 = BattleFieldUtils.project(wave.getSource(), wave.getAngle(gf), (double)(this.time - wave.getTime()) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            }
            g.setColor(Color.CYAN);
            for (int i = 0; i < wave.getShadows().size(); ++i) {
                Shadow shadow = wave.getShadows().get(i);
                Point2D.Double p1 = BattleFieldUtils.project(wave.getSource(), wave.getAngle(shadow.getMinGf() - step / 2.0), (double)(this.time - wave.getTime()) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                Point2D.Double p2 = BattleFieldUtils.project(wave.getSource(), wave.getAngle(shadow.getMaxGf() + step / 2.0), (double)(this.time - wave.getTime()) * Rules.getBulletSpeed((double)wave.getEnemyBulletPower()));
                g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            }
        }
        g.setColor(Color.LIGHT_GRAY);
        g.drawString("My bullet power: " + (double)Math.round(this.myBulletPower * 1000.0) / 1000.0, 10, 10);
        g.setColor(new Color(60, 60, 60));
        g.setColor(Color.RED);
        if (this.target != null) {
            g.drawLine((int)this.target.getX() - 18, (int)this.target.getY(), (int)this.target.getX() + 18, (int)this.target.getY());
            g.drawLine((int)this.target.getX(), (int)this.target.getY() - 18, (int)this.target.getX(), (int)this.target.getY() + 18);
        }
    }

    private void addMovementData(Features features, double guessFactor, ObservationType observationType) {
        movementObservations.add(new Observation(features, observationType, guessFactor));
        movement.addPoint(features, guessFactor, observationType);
    }

    private void addTargetingData(Features features, double guessFactor, ObservationType observationType) {
        targetingObservations.add(new Observation(features, observationType, guessFactor));
        targeting.addPoint(features, guessFactor, observationType);
    }

    static {
        myBulletPowerFired = 0.0;
        myBulletPowerHit = 0.0;
        opponentName = null;
        targeting = new DomogledTargeting();
        movement = new BaselineMovement();
        targetingObservations = new ArrayList();
        movementObservations = new ArrayList();
    }
}

