/*
 * Decompiled with CFR 0.152.
 */
package MGAM;

import MGAM.BotInfo;
import MGAM.Enemy;
import MGAM.EnemySelection;
import MGAM.Gun;
import MGAM.Movement;
import MGAM.Radar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public abstract class BotMaster
extends AdvancedRobot {
    public Radar radar;
    public Movement movement;
    public Gun gun;
    public EnemySelection selectEnemy;
    public static boolean paintGun = false;
    public static boolean paintMovement = false;
    public static boolean paintRadar = false;
    public Enemy enemy = new Enemy(this.getBotInfoStruct());
    public Enemy self = new Enemy(this.getBotInfoStruct());
    public static Hashtable<String, Enemy> enemies = new Hashtable();
    public static boolean melee = true;
    public static double battlefieldWidth;
    public static double battlefieldHeight;
    public static Rectangle2D.Double battlefieldRect;
    public static double shotsHit;
    public static double shotsMissed;
    public static double roundNum;
    static int[] place;
    public static BotMaster staticInstance;
    static boolean first;
    public boolean chumpShot = false;
    public boolean plannedShot = false;

    static {
        shotsHit = 0.0;
        shotsMissed = 0.0;
        roundNum = 0.0;
        place = new int[100];
        staticInstance = null;
        first = true;
    }

    public void run() {
        staticInstance = this;
        if (first) {
            int i = 0;
            while (i < 100) {
                BotMaster.place[i] = 0;
                ++i;
            }
            first = false;
        }
        this.setBodyColor(new Color(255, 255, 0));
        this.setGunColor(Color.black);
        this.setRadarColor(Color.green);
        this.setScanColor(Color.green);
        this.setBulletColor(Color.green);
        this.setAdjustRadarForRobotTurn(false);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        battlefieldWidth = this.getBattleFieldWidth();
        battlefieldHeight = this.getBattleFieldHeight();
        battlefieldRect = new Rectangle2D.Double(17.6, 17.6, battlefieldWidth - 35.2, battlefieldHeight - 35.2);
        this.initialize();
        while (true) {
            melee = this.getOthers() > 1;
            this.updateSelf();
            this.selectBehavior();
            this.executeBehavior();
        }
    }

    protected abstract void selectBehavior();

    protected abstract void initialize();

    protected abstract BotInfo getBotInfoStruct();

    private void executeBehavior() {
        this.selectEnemy.select();
        this.radar.scan();
        this.movement.move();
        this.gun.shoot();
        this.execute();
    }

    private void emitEvent(Event e) {
        if (this.radar != null) {
            this.radar.handleEvent(e);
        }
        if (this.movement != null) {
            this.movement.handleEvent(e);
        }
        if (this.gun != null) {
            this.gun.handleEvent(e);
        }
        if (this.selectEnemy != null) {
            this.selectEnemy.handleEvent(e);
        }
    }

    private void emitInputEvent(InputEvent e) {
        if (this.radar != null) {
            this.radar.handleInput(e);
        }
        if (this.movement != null) {
            this.movement.handleInput(e);
        }
    }

    public void updateSelf() {
        this.self.botInfo.dX = this.getX();
        this.self.botInfo.dY = this.getY();
        this.self.botInfo.dEnergy = this.getEnergy();
        this.self.botInfo.dHeading = this.getHeading();
        this.self.botInfo.dHeadingRad = this.getHeadingRadians();
    }

    public void onStatus(StatusEvent e) {
        this.emitEvent((Event)e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy oldData = enemies.get(e.getName());
        if (oldData == null) {
            oldData = new Enemy(this.getBotInfoStruct());
        }
        Enemy newData = oldData.update(e, this);
        enemies.put(e.getName(), newData);
        this.emitEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.emitEvent((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.emitEvent((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        this.emitEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.emitEvent((Event)e);
        shotsHit += 1.0;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.emitEvent((Event)e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.emitEvent((Event)e);
        shotsMissed += 1.0;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy died = enemies.get(e.getName());
        died.bDead = true;
        if (this.enemy != null && died.szName == this.enemy.szName) {
            this.enemy = null;
        }
        this.selectEnemy.select();
        this.emitEvent((Event)e);
    }

    public void onWin(WinEvent e) {
        int nInitialEnemyCount = 0;
        for (Enemy targetTank : enemies.values()) {
            ++nInitialEnemyCount;
            if (targetTank.bDead) continue;
        }
        place[0] = place[0] + 1;
        int i = 0;
        while (i < nInitialEnemyCount + 1) {
            this.out.println(String.valueOf(i + 1) + ":  " + place[i]);
            ++i;
        }
        this.finishRound();
        this.emitEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        int nInitialEnemyCount = 0;
        int numAlive = 0;
        for (Enemy targetTank : enemies.values()) {
            ++nInitialEnemyCount;
            if (targetTank.bDead) continue;
            ++numAlive;
        }
        int n = numAlive;
        place[n] = place[n] + 1;
        int i = 0;
        while (i < nInitialEnemyCount + 1) {
            this.out.println(String.valueOf(i + 1) + ":  " + place[i]);
            ++i;
        }
        this.finishRound();
        this.emitEvent((Event)e);
    }

    public void finishRound() {
        System.out.println("Shots Fired: " + (shotsHit + shotsMissed) / (roundNum += 1.0));
        System.out.println("Hit Rate: " + shotsHit / (shotsHit + shotsMissed));
        for (Enemy dudeGuy : enemies.values()) {
            dudeGuy.bDead = false;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.emitEvent((Event)e);
    }

    public void onKeyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == 'g') {
            paintGun = this.toggleButton(paintGun);
        }
        if (key == 'r') {
            paintRadar = this.toggleButton(paintRadar);
        }
        if (key == 'm') {
            paintMovement = this.toggleButton(paintMovement);
        }
        this.emitInputEvent(e);
    }

    public boolean toggleButton(boolean button) {
        return !button;
    }

    public void onKeyReleased(KeyEvent e) {
        this.emitInputEvent(e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onMousePressed(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onMouseReleased(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onPaint(Graphics2D g) {
        if (paintGun) {
            this.gun.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Gun", 0, 50);
        if (paintMovement) {
            this.movement.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Movement", 0, 75);
        if (paintRadar) {
            this.radar.onPaint(g);
            this.selectEnemy.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Radar", 0, 100);
    }
}

