/*
 * Decompiled with CFR 0.152.
 */
package techdude.Class2C.Systems;

import java.awt.geom.Point2D;
import techdude.Class2C.Systems.System;

public class Joel
extends System {
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double normalizeHeading(double heading) {
        return (heading % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double normalizeBearing(double bearing) {
        return Joel.normalizeHeading(bearing + Math.PI) - Math.PI;
    }

    public static double getBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.atan2(xo, yo);
    }

    public static double bulletVelocity(double power) {
        return 20.0 - (double)3 * power;
    }

    public static double bulletPowerFromVelocity(double velocity) {
        return (20.0 - velocity) / (double)3;
    }

    public static double maxBearing(double power) {
        return Math.abs(Math.asin(8.0 / Joel.bulletVelocity(power)));
    }

    public static int sign(double n) {
        return n < 0.0 ? -1 : 1;
    }

    public static double normalizeRelativeAngle(double angle) {
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static double absoluteBearing(Point source, Point target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    public static double radiansToDegrees(double __) {
        return __ * 180.0 / Math.PI;
    }

    public static double degreesToRadians(double __) {
        return __ * Math.PI / 180.0;
    }

    private Joel() {
    }

    public static class Point
    extends Point2D.Double {
        public double absoluteAngleTo(Point p) {
            double angle = Math.atan2(p.x - this.x, p.y - this.y);
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            while (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            return angle;
        }

        public Point project(double angle, double distance) {
            return new Point(this.x + Math.sin(angle) * distance, this.y + Math.cos(angle) * distance);
        }

        public Point() {
        }

        public Point(double x, double y) {
            super(x, y);
        }

        public Point(Point2D.Double p) {
            this(p.x, p.y);
        }
    }

    public static class RoboTrack
    extends MotionState {
        public String name;
        public double energy;
    }

    public static class MotionState
    extends Point {
        public double velocity;
        public double heading;
    }
}

