/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import java.util.Enumeration;
import techdude.forest.AbstractFightingStrategy;
import techdude.forest.FlamingForest;
import techdude.forest.TechDudeRecord;
import techdude.forest.TechDudeRecordCollection;

class SingleFightStrategy
extends AbstractFightingStrategy {
    public TechDudeRecord getTarget() {
        Enumeration allEnemys = FlamingForest.m_scannedInformation.elements();
        TechDudeRecordCollection currentInformation = null;
        TechDudeRecord bestTarget = null;
        while (allEnemys.hasMoreElements()) {
            currentInformation = (TechDudeRecordCollection)allEnemys.nextElement();
            if (!currentInformation.isCurrent()) continue;
            if (bestTarget == null) {
                bestTarget = currentInformation.get(0);
                continue;
            }
            if (currentInformation.get(0).getLife() < bestTarget.getLife()) {
                bestTarget = currentInformation.get(0);
                continue;
            }
            if (!(currentInformation.get(0).getDistance() < bestTarget.getDistance()) || currentInformation.get(0).getLife() != bestTarget.getLife()) continue;
            bestTarget = currentInformation.get(0);
        }
        FlamingForest.m_radarManager.setTarget(bestTarget);
        return bestTarget;
    }

    public double getPower(TechDudeRecord in_target) {
        boolean idle;
        TechDudeRecordCollection col = (TechDudeRecordCollection)FlamingForest.m_scannedInformation.get(in_target.getName());
        boolean bl = idle = col != null ? col.notMovingForTerms(2) : false;
        if (in_target.getDistance() < 200.0 || idle) {
            return 3;
        }
        if (in_target.getDistance() < 200.0) {
            return 2;
        }
        if (in_target.getDistance() > 500.0) {
            return 0.1;
        }
        return 1.1;
    }

    public boolean shouldShoot(TechDudeRecord in_target) {
        return true;
    }

    public boolean shouldUseStrategy() {
        boolean bl = false;
        if (this.m_owner.getOthers() == 1 || this.m_owner.getOthers() == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean expiredStrategy() {
        return this.shouldUseStrategy() ^ true;
    }

    public SingleFightStrategy(FlamingForest in_owner) {
        super(in_owner);
    }
}

