/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.antigravity;

import florent.XSeries.Configuration;
import florent.XSeries.movement.antigravity.GravEntity;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class GravPoint
extends GravEntity {
    public Point2D.Double point;
    public double strength = 50.0;
    public double dropOff = 2.0;

    public String getKey() {
        return String.valueOf(this.getClass().getSimpleName()) + "|" + this.point.toString();
    }

    protected double getMagnitude(Point2D.Double location) {
        return -this.strength / Math.pow(this.point.distance(location), this.dropOff);
    }

    public Force getForce(Point2D.Double location) {
        double angle = RobocodeTools.absoluteBearing(location, this.point);
        double magnitude = this.getMagnitude(location);
        Point2D.Double end = new Point2D.Double(location.x + magnitude * Math.sin(angle), location.y + magnitude * Math.cos(angle));
        return new Force(location, end);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        Force force = this.getForce(new Point2D.Double(Configuration.me.getX(), Configuration.me.getY()));
        force.multiplyMagnitude(100000.0);
        force.translateTo(this.point);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        g.drawString(this.getKey(), (float)this.point.x, (float)(Configuration.battleFieldHeigth - this.point.y));
    }
}

