/*
 * Decompiled with CFR 0.152.
 */
package florent.stats;

import florent.XSeries.radar.Tracker;
import florent.XSeries.utils.Pluggable;
import florent.XSeries.utils.RobocodeTools;
import florent.stats.ComplexStatData;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class StatKeeper
implements Pluggable {
    private static StatKeeper instance;
    private int[] places;
    private double damage;
    public int hits;
    private int skipped;
    public int walls;
    public long timeAlive;
    private AdvancedRobot me;
    private HashMap<String, ComplexStatData> data = new HashMap();
    private int survival;
    private int originalOthers;

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.me.getOthers() == 1 && Tracker.getInstance().getEnemies().size() == 1) {
            this.getStatData("duel:").record(this.me.getEnergy() - Tracker.getInstance().getEnemies().values().iterator().next().energy);
        }
    }

    public void onHitWall(HitWallEvent e) {
        ++this.walls;
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        ++this.hits;
        this.damage += 4.0 * e.getBullet().getPower() + (e.getBullet().getPower() > 1.0 ? 2.0 * (e.getBullet().getPower() - 1.0) : 0.0);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++this.skipped;
    }

    public void onPaint(Graphics2D g) {
    }

    public void onWin(WinEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onMainLoop() {
    }

    public void initRound() {
        if (this.places == null) {
            this.places = new int[this.me.getOthers() + 1];
        }
    }

    public void endRound() {
        this.survival += (this.originalOthers - this.me.getOthers()) * 50 + (this.me.getOthers() == 0 ? this.originalOthers * 10 : 0);
        this.timeAlive += this.me.getTime();
        int rounds = this.me.getRoundNum() + 1;
        int n = this.me.getOthers();
        this.places[n] = this.places[n] + 1;
        int i = 0;
        while (i < this.places.length) {
            RobocodeTools.log(String.valueOf(i + 1) + ":" + this.places[i] + "/" + 1.0 * (double)this.places[i] / (double)rounds * 100.0);
            ++i;
        }
        RobocodeTools.log("Skipped :" + 1.0 * (double)this.skipped / (1.0 * (double)this.timeAlive) * 100.0 + "%");
        RobocodeTools.log("Hits per round:" + 1.0 * (double)this.hits / (1.0 * (double)rounds));
        RobocodeTools.log("Damage per round:" + this.damage / (double)rounds);
        RobocodeTools.log("Survival per round:" + 1.0 * (double)this.survival / (double)rounds);
        RobocodeTools.log("Wall collision per round:" + 1.0 * (double)this.walls / (1.0 * (double)rounds));
        Iterator<ComplexStatData> it = this.data.values().iterator();
        while (it.hasNext()) {
            RobocodeTools.log(it.next().toString());
        }
        RobocodeTools.printMem();
    }

    private StatKeeper() {
    }

    public static StatKeeper getInstance() {
        if (instance == null) {
            instance = new StatKeeper();
        }
        return instance;
    }

    public void setMe(AdvancedRobot me) {
        this.me = me;
        this.originalOthers = me.getOthers();
    }

    public ComplexStatData getStatData(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        ComplexStatData newData = new ComplexStatData(key);
        this.data.put(key, newData);
        return newData;
    }
}

