/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.strategy.fire;

import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.PredictiveLinearTargeter;
import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.strategy.fire.FireStrategy;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;

public class FSPredictiveLinear
extends FireStrategy {
    private double FEstGunAngle = 0.0;
    private double FEstDist = 0.0;
    private Coordinate FEstImpactPoint = null;
    private ScannedRobotEvent FScanBotEvent = null;

    @Override
    protected boolean canHit() {
        return this.FEstImpactPoint.x() > 0.0 && this.FEstImpactPoint.x() < this.getBFWid() && this.FEstImpactPoint.y() > 0.0 && this.FEstImpactPoint.y() < this.getBFHeigh();
    }

    @Override
    public boolean isGoodTarget() {
        if (this.getTargetVelocity() < 0.5) {
            return true;
        }
        return this.getTargetDistance() < 1000.0;
    }

    @Override
    public double getGunAngle() {
        return this.FEstGunAngle;
    }

    @Override
    public double getEstimatedDist() {
        return this.FEstDist;
    }

    @Override
    public String getStrategyName() {
        return "fs_predicted_linear";
    }

    @Override
    public double getPower() {
        if (this.getTargetDistance() < 15.0) {
            return 11.0;
        }
        if (this.getTargetVelocity() < 0.001) {
            return 3.0;
        }
        if (this.getTargetVelocity() < 0.5) {
            if (this.getTargetDistance() < 100.0) {
                return 2.0;
            }
            return 1.0;
        }
        if (this.getTargetDistance() < 25.0) {
            return 2.0;
        }
        if (this.getTargetDistance() < 50.0) {
            return 1.5;
        }
        if (this.getTargetDistance() < 150.0) {
            return 1.0;
        }
        if (this.getTargetDistance() < 300.0) {
            return 0.5;
        }
        return 0.1;
    }

    @Override
    public void update(ScannedRobotEvent _sre, RobotStatus _rs, double angVelocityDegPerSec, double _bfHeigh, double _bfWid) {
        super.update(_sre, _rs, angVelocityDegPerSec, _bfHeigh, _bfWid);
        this.FScanBotEvent = _sre;
        this.calculate();
    }

    protected Coordinate getEstimatedPosition(double time) {
        double x = this.getTargetPos().x() + this.getTargetVelocity() * time * Math.sin(Math.toRadians(this.getTargetHeading()));
        double y = this.getTargetPos().y() + this.getTargetVelocity() * time * Math.cos(Math.toRadians(this.getTargetHeading()));
        return new Coordinate(x, y);
    }

    protected double f(double time) {
        double vb = 20.0 - 3.0 * this.getPower();
        this.FEstImpactPoint = this.getEstimatedPosition(time);
        double dX = this.FEstImpactPoint.x() - this.getMyPos().x();
        double dY = this.FEstImpactPoint.y() - this.getMyPos().y();
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    protected double getImpactTime(double t0, double t1, double accuracy) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }

    protected void calculate() {
        double impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.FEstImpactPoint = this.getEstimatedPosition(impactTime);
        double dX = this.FEstImpactPoint.x() - this.getMyPos().x();
        double dY = this.FEstImpactPoint.y() - this.getMyPos().y();
        this.FEstDist = Math.sqrt(dX * dX + dY * dY);
        this.FEstGunAngle = Math.toDegrees(Math.atan2(dX, dY));
        Debug.print(true, "CalcTargetAngle:" + Double.toString(this.FEstGunAngle));
        PredictiveLinearTargeter targetter = new PredictiveLinearTargeter();
        targetter.calculate(this.FScanBotEvent, this.getMyPos().x(), this.getMyPos().y(), this.getPower(), this.getMyHeading(), 0.0);
        this.FEstDist = targetter.distance;
        this.FEstGunAngle = targetter.bulletHeading_deg;
        this.FEstImpactPoint = targetter.impactPoint;
    }
}

