/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.Consts;
import emp.Enemy;
import emp.My;
import emp.Yngwie;
import java.util.Random;
import java.util.Vector;

public class Motor
implements Consts {
    private Yngwie yngwie;
    private Vector2D FieldVector;
    private Energy2D FieldEnergy;
    private Vector2D RuisVector;
    private double strafemult;
    private Energy2D[] GlobalEnergies;
    public Vector Aggressors;
    public Vector Threats;
    public boolean Collide;
    private static Random rand = new Random();

    public Motor(Yngwie yn) {
        this.yngwie = yn;
        this.FieldVector = new Vector2D(this.yngwie.getX(), this.yngwie.getY());
        this.FieldEnergy = new Energy2D(this, this.yngwie.getX(), this.yngwie.getY());
        this.RuisVector = new Vector2D(0.0, 0.0);
        this.strafemult = 1.0;
        this.Collide = false;
        this.GlobalEnergies = new Energy2D[16];
        this.Aggressors = new Vector(this.yngwie.getOthers());
        this.Threats = new Vector(10, 5);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double x = Yngwie.BattleFieldWidth * (double)(i + 1) / (double)5;
                double y = Yngwie.BattleFieldHeight * (double)(j + 1) / (double)5;
                this.GlobalEnergies[i * 4 + j] = new Energy2D(this, x, y);
            }
        }
    }

    private void UpdateAngryBullets() {
        this.Aggressors.clear();
        Enemy bestEn = Yngwie.EC.getBestEnemy();
        if (bestEn != null) {
            Enemy en;
            int Enemycount = 0;
            double a = 0.75;
            int i = 0;
            while (true) {
                if (i >= Yngwie.EC.Enemies.size()) break;
                en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
                if (en.TargetScore >= a * bestEn.TargetScore) {
                    ++Enemycount;
                }
                ++i;
            }
            i = 0;
            while (true) {
                if (i >= Yngwie.EC.Enemies.size()) break;
                en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
                if (!en.Death && (en.TargetScore >= a * bestEn.TargetScore || this.yngwie.getTime() - en.LastTimeHitMe < (long)30 || this.yngwie.Distance(en) < 500.0)) {
                    this.Aggressors.add(en);
                    double firePower = en.Fired();
                    if (firePower >= 0.09 && en.Time() == this.yngwie.getTime()) {
                        double y;
                        double x;
                        if (en.Records[en.RC - 1][0] - en.Records[en.RC - 2][0] == 1.0) {
                            x = en.Records[en.RC - 2][1];
                            y = en.Records[en.RC - 2][2];
                        } else {
                            x = en.X();
                            y = en.Y();
                        }
                        BulletThreat t = new BulletThreat(this, en.Name, x, y, firePower, this.yngwie.getTime() - (long)1);
                        this.Threats.add(t);
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.Threats.size()) {
            BulletThreat t = (BulletThreat)this.Threats.elementAt(i);
            double BulletRadius = t.Speed * (double)(this.yngwie.getTime() - t.TimeFired);
            if (My.Distance(this.yngwie.X, this.yngwie.Y, t.X, t.Y) + (double)18 < BulletRadius) {
                this.Threats.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    private void CalcFieldVector() {
        double strafeAngle;
        int j;
        int i;
        this.FieldVector.SetNewOrigin(this.yngwie.getX(), this.yngwie.getY());
        this.FieldVector.AddFieldObject(18.0, this.yngwie.getY(), 2000.0, 2.0);
        this.FieldVector.AddFieldObject(this.yngwie.getX(), Yngwie.BattleFieldHeight - 18.0, 2000.0, 2.0);
        this.FieldVector.AddFieldObject(Yngwie.BattleFieldWidth - 18.0, this.yngwie.getY(), 2000.0, 2.0);
        this.FieldVector.AddFieldObject(this.yngwie.getX(), 18.0, 2000.0, 2.0);
        if (!Yngwie.OneOnOne) {
            this.FieldVector.AddFieldObject(Yngwie.BattleFieldWidth / 2.0, Yngwie.BattleFieldHeight / 2.0, 150.0, 1.0);
        }
        this.FieldEnergy.SetNewOrigin(this.yngwie.getX(), this.yngwie.getY());
        this.FieldEnergy.AddFieldObject(18.0, this.FieldEnergy.OriginY, 2000.0, 2.0);
        this.FieldEnergy.AddFieldObject(this.FieldEnergy.OriginX, Yngwie.BattleFieldHeight - 18.0, 2000.0, 2.0);
        this.FieldEnergy.AddFieldObject(Yngwie.BattleFieldWidth - 18.0, this.FieldEnergy.OriginY, 2000.0, 2.0);
        this.FieldEnergy.AddFieldObject(this.FieldEnergy.OriginX, 18.0, 2000.0, 2.0);
        if (!Yngwie.OneOnOne) {
            this.FieldEnergy.AddFieldObject(Yngwie.BattleFieldWidth / 2.0, Yngwie.BattleFieldHeight / 2.0, 150.0, 1.0);
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                Energy2D e = this.GlobalEnergies[i * 4 + j];
                e.Z = 0.0;
                e.AddFieldObject(18.0, e.OriginY, 2000.0, 2.0);
                e.AddFieldObject(e.OriginX, Yngwie.BattleFieldHeight - 18.0, 2000.0, 2.0);
                e.AddFieldObject(Yngwie.BattleFieldWidth - 18.0, e.OriginY, 2000.0, 2.0);
                e.AddFieldObject(e.OriginX, 18.0, 2000.0, 2.0);
                if (Yngwie.OneOnOne) continue;
                e.AddFieldObject(Yngwie.BattleFieldWidth / 2.0, Yngwie.BattleFieldHeight / 2.0, 150.0, 1.0);
            }
        }
        i = 0;
        while (true) {
            if (i >= Yngwie.EC.Enemies.size()) break;
            Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
            if (!en.Death && en.Time() != (long)-1) {
                int k;
                if (en == this.yngwie.gunner.Target) {
                    this.FieldVector.AddFieldObject(en.X(), en.Y(), this.yngwie.getTargetField(), 1.0);
                    for (j = 0; j < 4; ++j) {
                        for (k = 0; k < 4; ++k) {
                            this.GlobalEnergies[j * 4 + k].AddFieldObject(en.X(), en.Y(), this.yngwie.getTargetField(), 1.0);
                        }
                    }
                    this.FieldEnergy.AddFieldObject(en.X(), en.Y(), this.yngwie.getTargetField(), 1.0);
                } else {
                    this.FieldVector.AddFieldObject(en.X(), en.Y(), 200.0, 1.0);
                    for (j = 0; j < 4; ++j) {
                        for (k = 0; k < 4; ++k) {
                            this.GlobalEnergies[j * 4 + k].AddFieldObject(en.X(), en.Y(), 200.0, 1.0);
                        }
                    }
                    this.FieldEnergy.AddFieldObject(en.X(), en.Y(), 200.0, 1.0);
                }
            }
            ++i;
        }
        Energy2D minE = this.GlobalEnergies[0];
        for (i = 1; i < 16; ++i) {
            if (!(this.GlobalEnergies[i].Z < minE.Z)) continue;
            minE = this.GlobalEnergies[i];
        }
        if (My.Distance(this.yngwie.getX(), this.yngwie.getY(), minE.OriginX, minE.OriginY) > this.yngwie.getBattleFieldWidth() / (double)5 && this.FieldEnergy.Z > minE.Z) {
            this.FieldVector.AddFieldObject(minE.OriginX, minE.OriginY, minE.Z - this.FieldEnergy.Z, 0.0);
        }
        Vector2D StrafeVector = new Vector2D(0.0, 0.0);
        StrafeVector.SetXY(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
        for (i = 0; i < this.Threats.size(); ++i) {
            BulletThreat t = (BulletThreat)this.Threats.elementAt(i);
            strafeAngle = My.AddDegrees(90.0, My.AngleFromTo(this.yngwie.getX(), this.yngwie.getY(), t.X, t.Y));
            if (strafeAngle >= 180.0) {
                strafeAngle -= 180.0;
            }
            double faktor = (2.0 * t.Power + 1.0) * Math.max(1.0, 0.01 * (400.0 - My.Distance(this.yngwie.getX(), this.yngwie.getX(), t.X, t.Y)));
            StrafeVector.X += faktor * My.sinDeg(strafeAngle);
            StrafeVector.Y += faktor * My.cosDeg(strafeAngle);
        }
        if (this.yngwie.gunner.Target != null) {
            strafeAngle = My.AddDegrees(90.0, this.yngwie.AngleTo(this.yngwie.gunner.Target));
            if (strafeAngle >= 180.0) {
                strafeAngle -= 180.0;
            }
            StrafeVector.X += My.sinDeg(strafeAngle);
            StrafeVector.Y += My.cosDeg(strafeAngle);
        }
        if (this.Collide) {
            this.strafemult *= (double)-1;
            this.Collide = false;
        } else if (Yngwie.OneOnOne && this.yngwie.gunner.Target != null && this.yngwie.Distance(this.yngwie.gunner.Target) < 300.0 && rand.nextDouble() < 0.15) {
            this.strafemult = rand.nextDouble() > 0.5 ? -1.0 : 1.0;
        } else if (Yngwie.OneOnOne && rand.nextDouble() < 0.1 || !Yngwie.OneOnOne && rand.nextDouble() < 0.15) {
            this.strafemult = rand.nextDouble() > 0.5 ? -1.0 : 1.0;
        }
        if (this.Threats.size() > 0) {
            StrafeVector.Multiply(this.strafemult * 2.0 / StrafeVector.Length());
        } else {
            StrafeVector.Multiply(this.strafemult / StrafeVector.Length());
        }
        if (Yngwie.OneOnOne) {
            StrafeVector.Multiply(0.7 / this.FieldVector.Length());
        } else {
            StrafeVector.Multiply(2.0 / StrafeVector.Length());
        }
        this.FieldVector.AddVector(StrafeVector);
    }

    public void Update() {
        this.UpdateAngryBullets();
        this.CalcFieldVector();
        double Vel = 5.0 + 3.0 * rand.nextDouble();
        if (this.yngwie.getVelocity() >= 0.0) {
            if (My.absADiffDeg(this.FieldVector.getAngle(), this.yngwie.getHeading()) > 110.0) {
                this.yngwie.control.setRobotVelocity(-Vel);
                this.yngwie.control.TurnTo(1, 3, My.AddDegrees(this.FieldVector.getAngle(), 180.0), false);
            } else {
                this.yngwie.control.setRobotVelocity(Vel);
                this.yngwie.control.TurnTo(1, 3, this.FieldVector.getAngle(), false);
            }
        } else if (My.absADiffDeg(this.FieldVector.getAngle(), this.yngwie.getHeading()) < 70.0) {
            this.yngwie.control.setRobotVelocity(Vel);
            this.yngwie.control.TurnTo(1, 3, this.FieldVector.getAngle(), false);
        } else {
            this.yngwie.control.setRobotVelocity(-Vel);
            this.yngwie.control.TurnTo(1, 3, My.AddDegrees(this.FieldVector.getAngle(), 180.0), false);
        }
    }

    public boolean Between(double X, double Y1, double Y2) {
        return X >= Y1 && X <= Y2 || X >= Y2 && X <= Y1;
    }

    private class BulletThreat {
        public double X;
        public double Y;
        public double Power;
        public double Speed;
        public long TimeFired;
        public String Name;

        public BulletThreat(Motor this$0, String vName, double vX, double vY, double vPower, long vTime) {
            this.X = vX;
            this.Y = vY;
            this.Power = vPower;
            this.TimeFired = vTime;
            this.Speed = My.getBulletVelocity(this.Power);
            this.Name = vName;
        }
    }

    private class Vector2D {
        public double OriginX;
        public double OriginY;
        public double X;
        public double Y;

        public Vector2D(double OrX, double OrY) {
            this.OriginX = OrX;
            this.OriginY = OrY;
            this.X = 0.0;
            this.Y = 0.0;
        }

        public void AddVector(Vector2D other) {
            this.X += other.X;
            this.Y += other.Y;
        }

        public void AddXY(double vX, double vY) {
            this.X += vX;
            this.Y += vY;
        }

        public void SetXY(double vX, double vY) {
            this.X = vX;
            this.Y = vY;
        }

        public void SetNewOrigin(double OrX, double OrY) {
            this.OriginX = OrX;
            this.OriginY = OrY;
            this.Y = 0.0;
            this.X = 0.0;
        }

        public void AddFieldObject(double atX, double atY, double Force, double Power) {
            double x2;
            double x1 = this.OriginX - atX;
            if (x1 == 0.0 & (x2 = this.OriginY - atY) == 0.0) {
                this.X += Force;
                this.Y += Force;
            } else {
                double resultant = Force / Math.pow(Math.sqrt(x1 * x1 + x2 * x2), Power + 1.0);
                this.X += x1 * resultant;
                this.Y += x2 * resultant;
            }
        }

        public double getAngle() {
            return My.AngleFromTo(((Motor)Motor.this).yngwie.X, ((Motor)Motor.this).yngwie.Y, ((Motor)Motor.this).yngwie.X + this.X, ((Motor)Motor.this).yngwie.Y + this.Y);
        }

        public void Multiply(double x) {
            this.X *= x;
            this.Y *= x;
        }

        public double Length() {
            return Math.sqrt(this.X * this.X + this.Y * this.Y);
        }
    }

    private class Energy2D {
        public double OriginX;
        public double OriginY;
        public double Z;

        public Energy2D(Motor this$0, double OrX, double OrY) {
            this.OriginX = OrX;
            this.OriginY = OrY;
            this.Z = 0.0;
        }

        public void SetNewOrigin(double OrX, double OrY) {
            this.OriginX = OrX;
            this.OriginY = OrY;
            this.Z = 0.0;
        }

        public void AddFieldObject(double atX, double atY, double Force, double Power) {
            double x2;
            double x1 = this.OriginX - atX;
            this.Z = x1 == 0.0 & (x2 = this.OriginY - atY) == 0.0 ? (this.Z += 10.0 * Force) : (this.Z += Force / Math.pow(Math.sqrt(x1 * x1 + x2 * x2), Power));
        }
    }
}

