/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.Consts;
import emp.Enemy;
import emp.My;
import emp.Yngwie;

public class Scanner
implements Consts {
    private Yngwie yngwie;
    private boolean ScanRound;
    private boolean Assist;
    private boolean EnemyFinding;
    private Enemy LostEnemy;
    public boolean TaskDone;
    private int Scans;
    private double lastHeading;
    private boolean CheckingProblem;
    private double ProblemHeading;
    private boolean FirstTime;
    private boolean RightSweeping;
    private long StartSweepTime;
    private long LastRoundCheck;
    private Enemy LeftSweepEnemy;
    private Enemy RightSweepEnemy;

    public Scanner(Yngwie y) {
        this.yngwie = y;
        this.lastHeading = 0.0;
        this.LeftSweepEnemy = null;
        this.RightSweepEnemy = null;
        this.RightSweeping = true;
        this.CheckingProblem = false;
        this.ProblemHeading = 0.0;
        this.StartSweepTime = 0L;
        this.LastRoundCheck = -1L;
        this.FirstTime = false;
        this.ScanRound();
    }

    public void CheckHeading(double heading) {
        double b;
        double a;
        if (this.Assist && this.LeftSweepEnemy != null && !My.IsAngleBetween(heading, a = this.yngwie.NextTurnAngleTo(this.LeftSweepEnemy), b = this.yngwie.NextTurnAngleTo(this.RightSweepEnemy))) {
            this.CheckingProblem = true;
            this.ProblemHeading = heading;
        }
    }

    private boolean CheckSweepCompleted() {
        if (this.StartSweepTime == this.yngwie.getTime()) {
            return false;
        }
        if (this.LeftSweepEnemy == null || this.LeftSweepEnemy.Death || this.RightSweepEnemy.Death) {
            int i = 0;
            while (true) {
                if (i >= Yngwie.EC.Enemies.size()) break;
                Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
                en.Scanned = true;
                ++i;
            }
            return true;
        }
        int i = 0;
        while (true) {
            if (i >= Yngwie.EC.Enemies.size()) break;
            Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
            if (this.yngwie.getTime() - en.Time() > (long)15 && this.yngwie.Distance(en) + (double)(this.yngwie.getTime() - en.Time()) * 8.0 >= 1200.0) {
                en.Scanned = true;
            }
            if (this.yngwie.motor.Aggressors.indexOf(en) == -1) {
                en.Scanned = true;
            }
            if (!en.Scanned) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void StartNewSweep() {
        double LeftSweepHeading = -1.0;
        double RightSweepHeading = -1.0;
        this.LeftSweepEnemy = null;
        this.RightSweepEnemy = null;
        double[] Headings = new double[this.yngwie.motor.Aggressors.size()];
        Enemy[] Enemies = new Enemy[this.yngwie.motor.Aggressors.size()];
        for (int i = 0; i < Enemies.length; ++i) {
            Enemy en = (Enemy)this.yngwie.motor.Aggressors.elementAt(i);
            en.Scanned = false;
            Headings[i] = this.yngwie.NextTurnAngleTo(en);
            Enemies[i] = en;
        }
        for (int i = 0; i < Enemies.length; ++i) {
            for (int j = i + 1; j < Enemies.length; ++j) {
                if (!(Headings[j] < Headings[i])) continue;
                double temp = Headings[i];
                Headings[i] = Headings[j];
                Headings[j] = temp;
                Enemy temp2 = Enemies[i];
                Enemies[i] = Enemies[j];
                Enemies[j] = temp2;
            }
        }
        if (Enemies.length == 0) {
            return;
        }
        if (Enemies.length == 1) {
            this.RightSweepEnemy = this.LeftSweepEnemy = Enemies[0];
        } else {
            double NotSweepArea = My.absADiffDeg2(Headings[Headings.length - 1], Headings[0]);
            this.RightSweepEnemy = Enemies[Enemies.length - 1];
            this.LeftSweepEnemy = Enemies[0];
            for (int i = 0; i < Enemies.length - 1; ++i) {
                double temp = My.absADiffDeg2(Headings[i], Headings[i + 1]);
                if (!(temp > NotSweepArea)) continue;
                NotSweepArea = temp;
                this.RightSweepEnemy = Enemies[i];
                this.LeftSweepEnemy = Enemies[i + 1];
            }
        }
        this.StartSweepTime = this.yngwie.getTime();
    }

    public void ScanRound() {
        this.Clear();
        this.ScanRound = true;
        this.StartSweepTime = this.yngwie.getTime();
    }

    public void AssistGunner() {
        this.Clear();
        this.Assist = true;
        this.FirstTime = true;
    }

    public void FindEnemy(Enemy en, boolean toRight) {
        this.Clear();
        this.EnemyFinding = true;
        this.LostEnemy = en;
        this.StartSweepTime = this.yngwie.getTime();
        this.RightSweeping = toRight;
    }

    public boolean AllSpotted() {
        int count = 0;
        int i = 0;
        while (true) {
            if (i >= Yngwie.EC.Enemies.size()) break;
            Enemy en = (Enemy)Yngwie.EC.Enemies.elementAt(i);
            if (!en.Death && en.Time() > this.StartSweepTime) {
                ++count;
            }
            ++i;
        }
        return count >= this.yngwie.getOthers();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void Update() {
        double curHeading;
        block30: {
            block33: {
                block34: {
                    block32: {
                        block31: {
                            curHeading = this.yngwie.getRadarHeading();
                            if (!this.ScanRound) break block31;
                            if (this.Scans > 8 || this.AllSpotted()) {
                                this.TaskDone = true;
                                this.ScanRound = false;
                                this.LastRoundCheck = this.yngwie.getTime();
                                this.AssistGunner();
                                this.Update();
                                break block30;
                            } else {
                                this.yngwie.control.TurnRightMax(3, 3);
                            }
                            break block30;
                        }
                        if (!this.EnemyFinding) break block32;
                        if (this.LostEnemy.Death || this.LostEnemy.Time() == this.yngwie.getTime()) {
                            this.AssistGunner();
                            this.Update();
                            return;
                        }
                        if (this.RightSweeping) {
                            this.yngwie.control.TurnRightMax(3, 3);
                            break block30;
                        } else {
                            this.yngwie.control.TurnLeftMax(3, 3);
                        }
                        break block30;
                    }
                    if (!this.Assist) break block30;
                    if (this.CheckingProblem) {
                        if (My.isToRightDeg(curHeading, this.ProblemHeading)) {
                            if (!My.isToRightDeg(this.ProblemHeading, this.lastHeading)) {
                                this.yngwie.control.TurnRightMax(3, 0);
                                return;
                            }
                            this.CheckingProblem = false;
                        } else {
                            if (!My.isToRightDeg(this.lastHeading, this.ProblemHeading)) {
                                this.yngwie.control.TurnLeftMax(3, 0);
                                return;
                            }
                            this.CheckingProblem = false;
                        }
                    }
                    if (this.yngwie.getTime() - this.yngwie.gunner.lastTimeFired >= (long)4 || this.yngwie.getTime() - this.LastRoundCheck <= (long)40) break block33;
                    if (this.yngwie.gunner.Target == null) break block34;
                    if (this.yngwie.getTime() - this.yngwie.gunner.Target.LastTimeFired >= (long)4 || !(this.yngwie.Distance(this.yngwie.gunner.Target) > 200.0)) break block33;
                }
                if (!Yngwie.OneOnOne) {
                    this.ScanRound();
                    this.Update();
                }
            }
            if (this.CheckSweepCompleted() || this.FirstTime) {
                this.FirstTime = false;
                this.StartNewSweep();
            }
            if (this.LeftSweepEnemy == null) {
                this.StartNewSweep();
                this.yngwie.control.TurnLeftMax(3, 2);
            } else if (this.LeftSweepEnemy == this.RightSweepEnemy && this.yngwie.getTime() - this.LeftSweepEnemy.Time() > (long)10) {
                this.yngwie.control.TurnLeftMax(3, 2);
            } else if (this.LeftSweepEnemy != null) {
                double LeftEnemyHeading = this.yngwie.NextTurnAngleTo(this.LeftSweepEnemy);
                if (!this.RightSweeping && My.IsAngleBetween(LeftEnemyHeading, curHeading, this.lastHeading) && this.LeftSweepEnemy.Time() != this.yngwie.getTime() && this.StartSweepTime != this.yngwie.getTime()) {
                    this.FindEnemy(this.LeftSweepEnemy, false);
                    this.Update();
                    return;
                }
                double RightEnemyHeading = this.yngwie.NextTurnAngleTo(this.RightSweepEnemy);
                if (this.RightSweeping && My.IsAngleBetween(RightEnemyHeading, this.lastHeading, curHeading) && this.RightSweepEnemy.Time() != this.yngwie.getTime() && this.StartSweepTime != this.yngwie.getTime()) {
                    this.FindEnemy(this.RightSweepEnemy, true);
                    this.Update();
                    return;
                }
                if (!My.IsAngleBetween(curHeading, LeftEnemyHeading, RightEnemyHeading)) {
                    this.RightSweeping = My.absADiffDeg2(curHeading, LeftEnemyHeading) < My.absADiffDeg2(RightEnemyHeading, curHeading);
                }
                if (this.RightSweeping) {
                    if (this.RightSweepEnemy == this.LeftSweepEnemy) {
                        this.yngwie.control.TurnRight(3, 3, My.absADiffDeg2(curHeading, this.yngwie.NextTurnAngleTo(this.RightSweepEnemy)) + 20.0);
                    } else {
                        double diff = My.absADiffDeg2(curHeading, this.yngwie.NextTurnAngleTo(this.RightSweepEnemy));
                        this.yngwie.control.TurnRight(3, 3, diff + 10.0);
                    }
                } else if (this.RightSweepEnemy == this.LeftSweepEnemy) {
                    this.yngwie.control.TurnLeft(3, 3, My.absADiffDeg2(this.yngwie.NextTurnAngleTo(this.LeftSweepEnemy), curHeading) + 20.0);
                } else {
                    double diff = My.absADiffDeg2(this.yngwie.NextTurnAngleTo(this.LeftSweepEnemy), curHeading);
                    this.yngwie.control.TurnLeft(3, 3, diff + 10.0);
                }
            }
        }
        ++this.Scans;
        this.lastHeading = curHeading;
    }

    private void Clear() {
        this.ScanRound = false;
        this.EnemyFinding = false;
        this.LostEnemy = null;
        this.Assist = false;
        this.TaskDone = false;
        this.Scans = 0;
    }
}

