/*
 * Decompiled with CFR 0.152.
 */
package tornyil.Lajcsi2.utils;

import java.awt.geom.Point2D;
import robocode.util.Utils;
import tornyil.Lajcsi2.utils.Lajcsi2Utils;

public class Wave {
    private double centerX;
    private double centerY;
    private double enemyAbsBearing;
    private double firePower;
    private double bulletVelocity;
    private boolean firing;
    private double enemyLateralVelocity;
    private long fireTime;
    private int enemyTangentialDirection;
    private double enemyDistance;
    private double maxEscapeAngle;
    private double gunHeadingWhenFired;
    private boolean alreadyPassed;

    public boolean isFiring() {
        return this.firing;
    }

    public double getDistance() {
        return this.enemyDistance;
    }

    public double getBFT() {
        return this.enemyDistance / this.bulletVelocity;
    }

    public double getLateralVelocity() {
        return this.enemyLateralVelocity;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.centerX, this.centerY);
    }

    public double getEnemyAbsBearing() {
        return this.enemyAbsBearing;
    }

    public double getGunHeadingWhenFired() {
        return this.gunHeadingWhenFired;
    }

    public boolean getAlreadyPassed() {
        return this.alreadyPassed;
    }

    public double maxEscapeAngle() {
        return this.maxEscapeAngle;
    }

    public void setFiring(boolean bl) {
        this.firing = bl;
    }

    public void setGunHeadingWhenFired(double d) {
        this.gunHeadingWhenFired = d;
    }

    public void setAlreadyPassed() {
        this.alreadyPassed = true;
    }

    public boolean passed(double d, double d2, long l) {
        boolean bl = false;
        if (Point2D.distance(this.centerX, this.centerY, d, d2) <= (double)(l - this.fireTime) * this.bulletVelocity) {
            bl = true;
        }
        return bl;
    }

    public double calcAngleOffset(double d, double d2) {
        double d3 = Math.atan2(d - this.centerX, d2 - this.centerY);
        return Utils.normalRelativeAngle((double)(d3 - this.enemyAbsBearing));
    }

    public double calcGuessFactor(double d) {
        return Math.max(-1.0, Math.min(1.0, d / this.maxEscapeAngle)) * (double)this.enemyTangentialDirection;
    }

    public Wave(double d, double d2, double d3, double d4, double d5, int n, long l, double d6, double d7, boolean bl) {
        this.centerX = d;
        this.centerY = d2;
        this.enemyAbsBearing = d3 + d4;
        this.firePower = d5;
        this.bulletVelocity = Lajcsi2Utils.bulletVelocity(d5);
        this.enemyTangentialDirection = n;
        this.fireTime = l;
        this.enemyLateralVelocity = d6;
        this.enemyDistance = d7;
        this.maxEscapeAngle = Math.asin(8.0 / this.bulletVelocity);
        this.firing = bl;
    }
}

