/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import apv.MovSim;
import apv.MovSimStat;
import florent.test.FUtils;
import florent.test.SpitterWave;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Spitter {
    private static final boolean TC = false;
    private static final double BULLET_MAX_POWER = 3.0;
    private static final double BULLET_POWER = 1.9;
    private static final double RESUME_FIRE_DISTANCE = 150.0;
    private static final MovSim sim = new MovSim();
    private AdvancedRobot me;
    private static int shots;
    private static int hits;
    private boolean holdFire = false;
    private boolean rammer = false;

    public void init(AdvancedRobot me) {
        this.me = me;
        SpitterWave.initClass(me);
    }

    public void holdFire() {
        this.holdFire = true;
    }

    public void fireAtWill() {
        this.holdFire = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        boolean aligned;
        SpitterWave.onScannedRobot(e);
        SpitterWave wave = new SpitterWave();
        Point2D.Double myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        double enemyAbsoluteBearing = this.me.getHeadingRadians() + e.getBearingRadians();
        Point2D.Double enemyLocation = FUtils.projectMotion(myLocation, enemyAbsoluteBearing, e.getDistance());
        SpitterWave.updateTargetLocation(enemyLocation);
        int bearingDirection = e.getVelocity() * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) < 0.0 ? -1 : 1;
        double power = this.power(e);
        wave.init(myLocation, enemyLocation, bearingDirection, power, e.getVelocity(), enemyAbsoluteBearing, e.getHeadingRadians(), e.getTime());
        this.me.addCustomEvent((Condition)wave);
        MovSimStat[] future = sim.futurePos(1, this.me);
        enemyLocation = FUtils.projectMotion(enemyLocation, e.getHeadingRadians(), e.getVelocity());
        enemyAbsoluteBearing = FUtils.absoluteBearing(new Point2D.Double(future[0].x, future[0].y), enemyLocation);
        double angle = wave.getAngle();
        this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.me.getGunHeadingRadians() + angle)));
        boolean bl = aligned = Math.abs(this.me.getGunTurnRemainingRadians()) < Math.abs(Math.atan(36.0 / e.getDistance()) / 2.0);
        if (!this.holdFire && aligned && (this.me.getEnergy() - power > 0.5 || e.getDistance() < 150.0) && this.me.setFireBullet(power) != null) {
            wave.setAligned(true);
            ++shots;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++hits;
    }

    public void dump() {
        System.out.println(this.getClass().getName());
        System.out.println("HR : " + 1.0 * (double)hits / (1.0 * (double)shots) * 100.0);
    }

    private double power(ScannedRobotEvent e) {
        if (1.0 * (double)hits / (1.0 * (double)shots) > 0.3) {
            return 3.0;
        }
        return Math.min(Math.min(e.getEnergy() / 4.0, this.me.getEnergy() / (double)(e.getDistance() >= 130.0 ? 5 : 1)), 1.9);
    }

    public void setRammer(boolean rammer) {
        this.rammer = rammer;
    }

    public void endRound() {
        SpitterWave.endRound();
    }
}

