/*
 * Decompiled with CFR 0.152.
 */
package com.arsenic;

import MyRobots.Attack;
import MyRobots.DataBullet;
import MyRobots.Drive;
import MyRobots.Rival;
import MyRobots.Scan;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class NewTest
extends AdvancedRobot {
    private Attack attack;
    private Drive drive;
    private Scan scan;
    private Rival rival;
    private byte aimType = 0;
    private double[] hitCount = new double[]{1.0, 1.0};
    private double[] missCount = new double[]{1.0, 1.0};
    private double[] hitRate = new double[]{0.0, 0.0};
    private boolean dir = true;
    boolean lastIsSide = false;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.black, Color.black, Color.black);
        this.setBulletColor(Color.gray);
        this.setScanColor(Color.yellow);
        this.attack = new Attack(this);
        this.drive = new Drive(this);
        this.scan = new Scan(this);
        this.rival = new Rival(this);
        while (true) {
            double randomX = Math.random();
            double randomY = Math.random();
            while (16 < this.scan.search()) {
                if (this.drive.relative(randomX, randomY) < 100.0) {
                    randomX = Math.random();
                    randomY = Math.random();
                    this.execute();
                }
                this.execute();
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double Eb = 0.0;
        int s = (int)(255.0 * Math.abs(Math.sin((double)this.getTime() * 0.2)));
        Color c = new Color(0, 0, 0);
        this.setColors(c, c, c);
        this.setScanColor(c);
        this.rival.updateRivalOnScannedRobot(e);
        switch (this.aimType) {
            case 0: {
                this.setBulletColor(Color.yellow);
                Eb = DataBullet.injection(this.attack.setFixedAim(e), (byte)0);
                break;
            }
            case 1: {
                this.setBulletColor(Color.red);
                Eb = DataBullet.injection(this.attack.setLinearAim(e), (byte)1);
            }
        }
        if (this.getGunHeat() == 0.0) {
            this.setFire(Eb);
            for (int i = 0; i < 2; ++i) {
                this.hitRate[i] = this.hitCount[i] / (this.hitCount[i] + this.missCount[i]);
            }
            this.aimType = Math.random() < 0.5 ? (this.hitRate[0] < this.hitRate[1] ? (byte)1 : 0) : (Math.random() < 0.5 ? (byte)1 : 0);
        }
        if (!this.lastIsSide && this.isSide()) {
            this.dir = !this.dir;
        }
        this.lastIsSide = this.isSide();
        if (e.getDistance() < 250.0 || this.rival.getFireRate() < 0.025 && 100L < this.getTime() || this.getOthers() != 1) {
            if (this.dir) {
                if (120.0 < e.getDistance()) {
                    this.setTurnRight(e.getBearing() + 45.0);
                } else {
                    this.setTurnRight(e.getBearing() + 135.0);
                }
                this.setAhead(100.0);
            } else {
                if (120.0 < e.getDistance()) {
                    this.setTurnRight(e.getBearing() + 135.0);
                } else {
                    this.setTurnRight(e.getBearing() + 45.0);
                }
                this.setBack(100.0);
            }
        } else if (this.rival.getFire() != 0.0) {
            if (Math.random() < 0.5) {
                this.setTurnRight(e.getBearing() + 90.0 - Math.random() * 40.0);
                this.setAhead(60.0 + Math.random() * 70.0);
            } else {
                this.setTurnRight(e.getBearing() + 90.0 + Math.random() * 40.0);
                this.setBack(60.0 + Math.random() * 70.0);
            }
        }
        this.scan.bind(e);
        this.execute();
    }

    public void onBulletHit(BulletHitEvent e) {
        this.rival.updateRivalOnBulletHit(e);
        byte by = DataBullet.extract(e.getBullet().getPower());
        this.hitCount[by] = this.hitCount[by] + 1.0;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        byte by = DataBullet.extract(e.getBullet().getPower());
        this.missCount[by] = this.missCount[by] + 1.0;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.rival.updateRivalOnHitByBullet(e);
    }

    public void onHitWall(HitWallEvent e) {
        this.dir = !this.dir;
        this.clearAllEvents();
    }

    public void onHitRobot(HitRobotEvent e) {
        double absoluteBearing = e.getBearing() + this.getHeading();
        double bearingFromRadar = Utils.normalRelativeAngleDegrees((double)(absoluteBearing - this.getRadarHeading()));
        this.setTurnRadarRight(bearingFromRadar);
        if (90.0 < Math.abs(e.getBearing())) {
            this.setAhead(30.0);
        } else {
            this.setAhead(-30.0);
        }
        this.execute();
        this.clearAllEvents();
    }

    public void onWin(WinEvent e) {
        this.setColors(Color.white, Color.white, Color.white);
        this.setScanColor(Color.white);
    }

    double absoluteAngle(double r) {
        if ((r %= 360.0) < 0.0) {
            r = 360.0 + r;
        }
        return r;
    }

    boolean isSide() {
        return this.getBattleFieldWidth() - 80.0 < this.getX() || this.getX() < 80.0 || this.getBattleFieldHeight() - 80.0 < this.getY() || this.getY() < 80.0;
    }
}

