/*
 * Decompiled with CFR 0.152.
 */
package ola;

import ola.Coordinate;
import ola.Direction;
import ola.DriverDirective;
import ola.TurnAndSpeed;

public abstract class AvoidLine
extends DriverDirective {
    private static final double MAX_PRIO = 100.0;
    private static final double MAX_EFFECTIVE_DISTANCE = 100.0;
    private static final double PRIO_DECLINE_RATE = 1.0;
    private static final double MAX_SPEED = 8.0;
    private static final double SPEED_INCREASERATE = 0.08;
    private static final double MIN_SPEED = 1.0;
    private static final int QUARTER_TURN = 90;
    private double currentPos;
    private double avoid;
    private Direction currentHeading;
    private Direction directOn;

    public AvoidLine(double avoid, Direction directOn, Coordinate currentPos, Direction currentHeading) {
        this.currentPos = this.getCurrent(currentPos);
        this.avoid = avoid;
        this.directOn = directOn;
        this.currentHeading = currentHeading;
    }

    protected abstract double getCurrent(Coordinate var1);

    @Override
    public TurnAndSpeed drive() {
        double turn;
        double speed = 1.0 + 0.08 * this.dist();
        double difference = this.currentHeading.compassDiff(this.directOn);
        if (difference > (double)Math.abs(100)) {
            turn = 0.0;
        } else {
            double leftOrRight = this.leftOrRight(difference);
            turn = leftOrRight * 90.0;
        }
        return new TurnAndSpeed(turn, speed);
    }

    private double leftOrRight(double difference) {
        double leftOrRight1 = Math.copySign(1.0, difference);
        return leftOrRight1;
    }

    @Override
    public double priority() {
        double dist = this.dist();
        double distancePrio = 100.0 - 1.0 * dist;
        double prio = Math.max(distancePrio, 0.0);
        return prio;
    }

    private double dist() {
        return Math.abs(this.avoid - this.currentPos);
    }
}

