/*
 * Decompiled with CFR 0.152.
 */
package ola;

import ola.Coordinate;
import ola.Direction;
import ola.DriverDirective;
import ola.Log;
import ola.TurnAndSpeed;

public class CircleTarget
extends DriverDirective {
    private static final int ADJUST = 20;
    private static final int QUARTER_TURN = 90;
    private static final int TOO_CLOSE = 200;
    private static final int TOO_FAR = 400;
    private static final double CLOSE_ENOUGH = 4.0;
    private Coordinate currentPos;
    private Direction currentHeading;
    private Coordinate selectTarget;

    public CircleTarget(Coordinate currentPos, Direction currentHeading, Coordinate selectTarget) {
        this.currentPos = currentPos;
        this.currentHeading = currentHeading;
        this.selectTarget = selectTarget;
    }

    @Override
    public TurnAndSpeed drive() {
        Direction directionToTarget = this.currentPos.directionTo(this.selectTarget);
        double diffFromTargetDir = this.currentHeading.compassDiff(directionToTarget);
        double direction = this.leftOrRight(diffFromTargetDir);
        Direction wantedDir = directionToTarget.turn(90.0 * direction);
        if (this.tooClose()) {
            wantedDir = wantedDir.turn(20.0 * direction);
        } else if (this.tooFar()) {
            wantedDir = wantedDir.turn(-20.0 * direction);
        }
        double diffFromWanted = wantedDir.compassDiff(this.currentHeading);
        double turn = 0.0;
        turn = Math.abs(diffFromWanted) < 4.0 ? 0.0 : diffFromWanted;
        Log.value("currentHeading", this.currentHeading);
        Log.value("directionToTarget", directionToTarget);
        Log.value("wantedDir", wantedDir);
        Log.value("diffFromWanted", diffFromWanted);
        Log.value("turn", turn);
        return new TurnAndSpeed(turn, 8.0);
    }

    private boolean tooFar() {
        return this.currentPos.distance(this.selectTarget) > 400.0;
    }

    private boolean tooClose() {
        return this.currentPos.distance(this.selectTarget) < 200.0;
    }

    private double leftOrRight(double compassDiff) {
        return Math.copySign(1.0, compassDiff);
    }

    @Override
    public double priority() {
        if (this.selectTarget == null) {
            return 0.0;
        }
        return 2.0;
    }
}

