/*
 * Decompiled with CFR 0.152.
 */
package ola;

import java.util.Formatter;
import ola.Direction;

public class Coordinate {
    private static final double ALMOST_NOTHING = 1.0E-15;
    private double y;
    private double x;

    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Coordinate(Coordinate possision) {
        this(possision.x, possision.y);
    }

    public Coordinate moveRad(double distance, double direction) {
        double newX = this.x + distance * Math.sin(direction);
        double newY = this.y + distance * Math.cos(direction);
        return new Coordinate(newX, newY);
    }

    public Coordinate moveDeg(double distance, double direction) {
        return this.moveRad(distance, Math.toRadians(direction));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        new Formatter(s).format("%.2fx%.2f", this.x, this.y);
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            Coordinate other = (Coordinate)obj;
            return this.almostEqual(this.x, other.x) && this.almostEqual(this.y, other.y);
        }
        return false;
    }

    private boolean almostEqual(double a, double b) {
        double diff = a - b;
        return diff < 1.0E-15;
    }

    public Coordinate move(double distance, Direction direction) {
        return this.moveDeg(distance, direction.getDegrees());
    }

    protected double distance(Coordinate other) {
        double distance = Math.sqrt(Math.pow(this.xDiff(other), 2.0) + Math.pow(this.yDiff(other), 2.0));
        return distance;
    }

    private double yDiff(Coordinate other) {
        return other.y - this.y;
    }

    private double xDiff(Coordinate other) {
        return other.x - this.x;
    }

    public Direction directionTo(Coordinate other) {
        double yDiff = this.yDiff(other);
        double xDiff = this.xDiff(other);
        double tan = xDiff / yDiff;
        double atanRad = Math.atan(tan);
        Direction direction = new Direction(Math.toDegrees(atanRad));
        if (yDiff < 0.0) {
            direction = direction.turn(180.0);
        }
        return direction;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }
}

