/*
 * Decompiled with CFR 0.152.
 */
package ola;

import java.util.Formatter;
import ola.Coordinate;
import ola.Direction;
import ola.Movment;

public class MovingObject {
    private String name;
    private Movment movement;
    private long time;
    private Coordinate pos;

    public MovingObject(long time, Coordinate pos, Movment movment, String name) {
        this.pos = pos;
        this.time = time;
        this.movement = movment;
        this.name = name;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        new Formatter(s).format("%s : seen at time:%s at pos:%s moving:%s", this.name, this.time, this.pos, this.movement);
        return s.toString();
    }

    public Direction getDirection() {
        return this.movement;
    }

    public double getVelocity() {
        return this.movement.getVelocity();
    }

    public Coordinate getPossision() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public Coordinate getExpectedPossision(long currentTime) {
        long moveTime = currentTime - this.time;
        double movedDistance = this.movement.movedDistance(moveTime);
        Coordinate currentPos = this.pos.move(movedDistance, this.movement);
        return currentPos;
    }
}

