/*
 * Decompiled with CFR 0.152.
 */
package pla;

public class TargetInfo {
    String name;
    public double bearing;
    public double bearingRad;
    public double heading;
    public double headingRad;
    public long ctime;
    public double velocity;
    public double x;
    public double y;
    public double distance;
    public double energy;
    public double previousEnergy;

    public void setEnergy(double newEnergy) {
        this.previousEnergy = this.energy;
        this.energy = newEnergy;
    }

    public double getEnergyDifference() {
        return this.previousEnergy - this.energy;
    }

    public boolean bulletFired() {
        double energyDiff = this.previousEnergy - this.energy;
        return energyDiff > 0.0 && energyDiff <= 3.0;
    }

    public double bulletEnergy() {
        return this.previousEnergy - this.energy;
    }

    public double guessX(long when) {
        long diff = when - this.ctime;
        return this.x + Math.sin(this.headingRad) * this.velocity * (double)diff;
    }

    public double guessY(long when) {
        long diff = when - this.ctime;
        return this.y + Math.cos(this.headingRad) * this.velocity * (double)diff;
    }

    TargetInfo() {
        String name = "";
        this.bearing = 0.0;
        this.bearingRad = 0.0;
        this.heading = 0.0;
        this.headingRad = 0.0;
        this.ctime = 0L;
        this.velocity = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.distance = 0.0;
        this.energy = 100.0;
        this.previousEnergy = 100.0;
    }
}

