/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Bearing;
import shrub.Box;
import shrub.Heading;
import shrub.HistoricIterator;
import shrub.InterceptSolution;
import shrub.Line;
import shrub.Location;
import shrub.MoveHistory;
import shrub.Movement;
import shrub.PredictorAPI;
import shrub.ShrubMath;

public class PHPredictor
implements PredictorAPI {
    private long mMinTimeDelta = 1L;
    private long mMaxInterceptTime = 9999L;
    private Box mMovementArea = null;
    private Box mInterceptArea = null;
    private double mMaxAngleOverride = 10.0;
    private int mPeriodicity = 50;
    private static NumberFormat dp2 = NumberFormat.getInstance();

    public void SetMinTimeDelta(long newValue) {
        this.mMinTimeDelta = newValue;
    }

    public void SetMovementArea(Box newValue) {
        this.mMovementArea = newValue;
    }

    public void SetInterceptArea(Box newValue) {
        this.mInterceptArea = newValue;
    }

    public void SetMaxInterceptTime(long newValue) {
        this.mMaxInterceptTime = newValue;
    }

    public void SetMaxAngleOverride(long newValue) {
        this.mMaxAngleOverride = newValue;
    }

    public void SetPeriodicity(int newValue) {
        this.mPeriodicity = newValue;
    }

    public final InterceptSolution Intercept(double minSpeedAllowed, double maxSpeedAllowed, Location subLocn, Heading subHdng, MoveHistory objHistory) {
        Location wallIntLocn;
        double distToWall;
        int maxTimeToWall;
        boolean okSoFar = true;
        InterceptSolution intSoln = new InterceptSolution();
        Movement objStartMove = objHistory.GetLastMove();
        long startTime = objStartMove.GetTimeNow();
        Location objStartLocn = objStartMove.GetLocnNow();
        double objStartDist = objStartLocn.DistanceTo(subLocn);
        long earliestHit = (long)(objStartDist / (maxSpeedAllowed + 8.0));
        long latestHit = (long)(objStartDist / (minSpeedAllowed - 8.0));
        Line subLine = Line.valueOfStartHdng(subLocn, subHdng);
        if (this.mInterceptArea != null && latestHit > (long)(maxTimeToWall = (int)((distToWall = (wallIntLocn = this.mInterceptArea.EdgeIntersectOutward(subLine)).DistanceTo(subLocn)) / minSpeedAllowed))) {
            latestHit = maxTimeToWall;
        }
        if (latestHit > this.mMaxInterceptTime) {
            latestHit = this.mMaxInterceptTime;
        }
        earliestHit += startTime;
        latestHit += startTime;
        HistoricIterator histIterator = new HistoricIterator(objHistory, objStartMove, this.mMovementArea, this.mPeriodicity);
        okSoFar &= histIterator.IsOkay();
        boolean finished = false;
        boolean validSolutionFound = false;
        double lastValidSpeed = -1.0;
        boolean angleOverrideFound = false;
        double bestAngleOverride = 999999.0;
        long priorPredictTime = startTime;
        while (okSoFar && !finished) {
            if (!(okSoFar &= histIterator.Iterate())) {
                System.out.println("PHPredictor, iterator gone bad (PH)");
                break;
            }
            Movement predictMove = histIterator.getIteratingMove();
            long predictTime = predictMove.GetTimeNow();
            if (predictTime > latestHit) {
                finished = true;
                continue;
            }
            if (predictTime < earliestHit || predictTime - priorPredictTime < this.mMinTimeDelta) continue;
            priorPredictTime = predictTime;
            Location predictLocn = predictMove.GetLocnNow();
            double predictDist = predictLocn.DistanceTo(subLocn);
            double angularTolDeg = ShrubMath.RobotAngularWidth(predictDist);
            Heading hdngToPredict = Heading.valueOfFromTo(subLocn, predictLocn);
            Bearing angleOff = Bearing.valueOfFromTo(subHdng, hdngToPredict);
            long deltaTime = predictTime - startTime;
            double bulletSpeed = predictDist / (double)deltaTime;
            double loSpeedToHit = (predictDist - 20.0) / (double)deltaTime;
            double hiSpeedToHit = (predictDist + 30.0) / (double)deltaTime;
            if (!(loSpeedToHit <= maxSpeedAllowed) || !(hiSpeedToHit >= minSpeedAllowed)) continue;
            double angleOff_Abs = angleOff.GetAbs();
            if (angleOff_Abs <= angularTolDeg) {
                lastValidSpeed = bulletSpeed > maxSpeedAllowed ? maxSpeedAllowed : (bulletSpeed < minSpeedAllowed ? minSpeedAllowed : bulletSpeed);
                validSolutionFound = true;
                continue;
            }
            if (!(angleOff_Abs <= this.mMaxAngleOverride) || !(angleOff_Abs < Math.abs(bestAngleOverride))) continue;
            bestAngleOverride = angleOff.Get();
            angleOverrideFound = true;
        }
        if (validSolutionFound) {
            intSoln.mSpeed = lastValidSpeed;
        } else if (angleOverrideFound) {
            intSoln.mBearing = bestAngleOverride;
        }
        return intSoln;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

