/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.BattleStats;

public class RoundStats {
    private long mNumTotalTurns = 0L;
    private long mNumTurnsSkipped = 0L;
    private long mNumShotsFired = 0L;
    private long mNumShotsHit = 0L;
    private long mNumShotsMissed = 0L;
    private long mNumBulletCollisions = 0L;
    private long mFirstShotTime = 0L;
    private long mLastShotTime = 0L;
    private double mAvgeShotPower = 0.0;
    private double mAvgeShotInterval = 0.0;
    private long mNumNoLockOn = 0L;
    private long mNumWaypointTimeouts = 0L;
    private long mNumTimesRammer = 0L;
    private long mNumTimesRammee = 0L;
    private long mNumTimesHitWall = 0L;
    private long mNumTimesHitByBullet = 0L;
    private final BattleStats mBattleStats = BattleStats.getInstance();
    private NumberFormat dp2 = NumberFormat.getInstance();
    private static RoundStats THE_INSTANCE = new RoundStats();

    public static RoundStats getInstance() {
        return THE_INSTANCE;
    }

    private RoundStats() {
        this.initialiseInternal();
    }

    public void initialise() {
        this.initialiseInternal();
    }

    private void initialiseInternal() {
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
        this.mNumTotalTurns = 0L;
        this.mNumTurnsSkipped = 0L;
        this.mNumShotsFired = 0L;
        this.mNumShotsHit = 0L;
        this.mNumShotsMissed = 0L;
        this.mNumBulletCollisions = 0L;
        this.mFirstShotTime = 0L;
        this.mLastShotTime = 0L;
        this.mAvgeShotPower = 0.0;
        this.mAvgeShotInterval = 0.0;
        this.mNumNoLockOn = 0L;
        this.mNumWaypointTimeouts = 0L;
        this.mNumTimesRammer = 0L;
        this.mNumTimesRammee = 0L;
        this.mNumTimesHitWall = 0L;
        this.mNumTimesHitByBullet = 0L;
    }

    public void shotHit() {
        ++this.mNumShotsHit;
    }

    public void shotMissed() {
        ++this.mNumShotsMissed;
    }

    public void bulletCollision() {
        ++this.mNumBulletCollisions;
    }

    public void skippedTurn() {
        ++this.mNumTurnsSkipped;
    }

    public void noLockOn() {
        ++this.mNumNoLockOn;
    }

    public void shotFired(long thisTime, double thisPower) {
        if (this.mNumShotsFired <= 0L) {
            this.mAvgeShotInterval = thisTime;
            this.mAvgeShotPower = thisPower;
            this.mNumShotsFired = 1L;
            this.mFirstShotTime = thisTime;
            this.mLastShotTime = thisTime;
        } else if (this.mNumShotsFired == 1L) {
            ++this.mNumShotsFired;
            this.mAvgeShotPower = (this.mAvgeShotPower + thisPower) / 2.0;
            this.mAvgeShotInterval = thisTime - this.mLastShotTime;
            this.mLastShotTime = thisTime;
        } else {
            long thisInterval = thisTime - this.mLastShotTime;
            double totalPowerSoFar = this.mAvgeShotPower * (double)this.mNumShotsFired + thisPower;
            double totalIntervalSoFar = this.mAvgeShotInterval * (double)(this.mNumShotsFired - 1L) + (double)thisInterval;
            ++this.mNumShotsFired;
            this.mAvgeShotPower = totalPowerSoFar / (double)this.mNumShotsFired;
            this.mAvgeShotInterval = totalIntervalSoFar / (double)(this.mNumShotsFired - 1L);
            this.mLastShotTime = thisTime;
        }
    }

    public void waypointTimeout() {
        ++this.mNumWaypointTimeouts;
    }

    public void rammerOfRobot() {
        ++this.mNumTimesRammer;
    }

    public void rammedByRobot() {
        ++this.mNumTimesRammee;
    }

    public void hitWall() {
        ++this.mNumTimesHitWall;
    }

    public void hitByBullet() {
        ++this.mNumTimesHitByBullet;
    }

    public void endRound(long timeNow) {
        this.mNumTotalTurns = timeNow + 1L;
        this.printStats();
        this.mBattleStats.endRound(this.mNumTotalTurns, this.mNumTurnsSkipped, this.mNumShotsFired, this.mNumShotsHit, this.mNumShotsMissed, this.mNumBulletCollisions);
    }

    private void printStats() {
        double hitPct = 0.0;
        long totalResolvedShots = this.mNumShotsHit + this.mNumShotsMissed;
        if (totalResolvedShots > 0L) {
            hitPct = 100.0 * (double)this.mNumShotsHit / (double)totalResolvedShots;
        }
        double skipPct = 0.0;
        if (this.mNumTotalTurns > 0L) {
            skipPct = 100.0 * (double)this.mNumTurnsSkipped / (double)this.mNumTotalTurns;
        }
        System.out.println();
        System.out.println("========== Round stats ==========");
        System.out.println("---My shooting---");
        System.out.println("Shots/HitBlt/Remain: " + this.mNumShotsFired + " / " + this.mNumBulletCollisions + " / " + (this.mNumShotsFired - this.mNumBulletCollisions));
        System.out.println("Hit/Missed/HitPct:   " + this.mNumShotsHit + " / " + this.mNumShotsMissed + " / " + this.dp2.format(hitPct) + "%");
        System.out.println("AvgTime/AvgPower:    " + this.dp2.format(this.mAvgeShotInterval) + " / " + this.dp2.format(this.mAvgeShotPower));
        System.out.println("FirstShot/LastShot:  " + this.mFirstShotTime + " / " + this.mLastShotTime);
        System.out.println("---Collisions---");
        System.out.println("Blt/Ram/Rammed/Wall: " + this.mNumTimesHitByBullet + " / " + this.mNumTimesRammer + " / " + this.mNumTimesRammee + " / " + this.mNumTimesHitWall);
        System.out.println("---Other stuff---");
        System.out.println("Timeouts/NoLock:     " + this.mNumWaypointTimeouts + " / " + this.mNumNoLockOn);
        System.out.println("Turns/Skips/SkipPct: " + this.mNumTotalTurns + " / " + this.mNumTurnsSkipped + " / " + this.dp2.format(skipPct) + "%");
    }
}

