/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.move;

import catcat20.helios.move.NonWaveMove;
import catcat20.helios.move.path.Path;
import catcat20.helios.move.path.PathPos;
import catcat20.helios.move.plan.DuelPlan;
import catcat20.helios.move.plan.MeleePlan;
import catcat20.helios.move.plan.RamEscapePlan;
import catcat20.helios.move.plan.SurfPlan;
import catcat20.helios.move.plan.TronPlan;
import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.robot.Bot;
import catcat20.helios.utils.HConstants;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.Intersection;
import catcat20.helios.utils.MovementPredictor;
import catcat20.helios.utils.PreciseWallSmooth;
import catcat20.helios.utils.Wave;
import catcat20.helios.utils.knn.GFData;
import catcat20.helios.utils.knn.TreeGFData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Surfing {
    public static double duelHitCount = 0.0;
    public static double duelFiredCount = 0.0;
    public static double meleeHitCount = 0.0;
    public static double meleeFiredCount = 0.0;
    public long pathTime;
    public long dangerTime;
    public int dangerCalled = 0;
    public int treeNodes = 0;
    public int cutNodes = 0;
    public double waveDangerSum = 0.0;
    public double waveDangerCount = 1.0;
    public double averageWaveDanger = 0.0;
    public double posDangerSum = 2.0;
    public double posDangerCount = 1.0;
    public double averagePosDanger = 0.0;
    public TeamRobot _robot;
    public int _others;
    public String _myName;
    public double _myEnergy;
    Point2D.Double _centerPos;
    public Point2D.Double _myPos;
    public long _time;
    public ArrayList<Wave> _waves;
    public ArrayList<Wave> _tickWaves;
    public static int WALL_STICK = 160;
    public static int MAX_SURF = 3;
    public static final int BACK_AMOUNT_LOG = 1;
    public boolean paint = false;
    public boolean oldPaint = false;
    public TronPlan tronPlan = new TronPlan();
    public DuelPlan duelPlan = new DuelPlan();
    public MeleePlan meleePlan = new MeleePlan();
    public RamEscapePlan ramEscapePlan = new RamEscapePlan();
    public SurfPlan currentPlanner;
    public NonWaveMove nonWaveMove;
    public int waveCount = 0;
    public final Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, Color.pink};
    BasicStroke bs = new BasicStroke(3.0f);

    public Surfing(TeamRobot robot) {
        this._robot = robot;
        this.nonWaveMove = new NonWaveMove(robot);
    }

    public Color waveColor() {
        ++this.waveCount;
        if (this.waveCount >= this.colors.length) {
            this.waveCount = 0;
        }
        return this.colors[this.waveCount];
    }

    public void init() {
        this._waves = new ArrayList();
        this._tickWaves = new ArrayList();
    }

    public void onTick() {
        this._others = this._robot.getOthers();
        this._centerPos = new Point2D.Double(HConstants.fieldWidth / 2.0, HConstants.fieldHeight / 2.0);
        this.averageWaveDanger = this.waveDangerSum / this.waveDangerCount;
        this.averagePosDanger = this.posDangerSum / this.posDangerCount;
        this.waveDangerSum = 0.0;
        this.waveDangerCount = 0.0;
        this.posDangerSum = 0.0;
        this.posDangerCount = 0.0;
        this._time = this._robot.getTime();
        this._myName = this._robot.getName();
        this._myEnergy = this._robot.getEnergy();
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        if (this._robot.getOthers() <= 1) {
            this.currentPlanner = this.duelPlan;
            if (HeliosRadar.nearestBot != null && HeliosRadar.nearestBot.currentState != null && HeliosRadar.nearestBot.currentState.getEnergy() > 0.0 && (this._waves.isEmpty() || HeliosRadar.nearestBot.currentState.getPosition().distance(this._myPos) <= 200.0)) {
                this.currentPlanner = this.ramEscapePlan;
            }
            MAX_SURF = 3;
        } else {
            this.currentPlanner = this.meleePlan;
            MAX_SURF = 3;
        }
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (Bot bot : HeliosRadar.enemies.values()) {
            Wave w;
            if (this._robot.isTeammate(bot.name) || !bot.alive || bot.botStateLogs.size() < 2) continue;
            Wave tickWave = new Wave(bot.botStateLogs.get(1).getPosition());
            tickWave.fireTime = (long)((double)(bot.lastScanTime + time) / 2.0) - 2L;
            tickWave.rammerWave = true;
            tickWave.bulletPower = bot.predictNextPower(this._robot, 1.95);
            tickWave.directAngle = HUtils.absoluteBearing(bot.botStateLogs.get(1).getPosition(), HeliosRadar.oldMyStates.get(1).getPosition());
            tickWave.enName = bot.name;
            tickWave.isMeleeWave = others > 1;
            tickWave.enState = bot.botStateLogs.get(1);
            tickWave.myState = HeliosRadar.currentMyState;
            tickWave.prevMyState = HeliosRadar.oldMyStates.get(1);
            tickWave.direction = HUtils.sign(bot.myLatVel);
            tickWave.myDirChangeTime = bot.myDirChangeTime;
            tickWave.myDist10 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(11, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            tickWave.myDist16 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(17, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            tickWave.myDist30 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(31, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            tickWave.myDist60 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(61, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            tickWave.myDist120 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(121, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            tickWave.currentGF = tickWave.guessFactor(this._myPos);
            if (bot.lastSurfTickWave != null) {
                bot.lastSurfTickWave.tickNext = tickWave;
                tickWave.tickBack = bot.lastSurfTickWave;
            }
            bot.lastSurfTickWave = tickWave;
            double energyDrop = bot.botStateLogs.get(1).getEnergy() - bot.currentState.getEnergy();
            if (energyDrop > 0.0 && energyDrop <= 3.01) {
                if (others > 1 && !bot.canFire) continue;
                if (others <= 1) {
                    duelFiredCount += 1.0;
                } else {
                    meleeFiredCount += 1.0;
                }
                bot.canFire = false;
                w = new Wave(bot.botStateLogs.get(1).getPosition());
                w.fireTime = (long)((double)(bot.lastScanTime + time) / 2.0) - 2L;
                w.bulletPower = energyDrop;
                w.directAngle = HUtils.absoluteBearing(bot.botStateLogs.get(1).getPosition(), HeliosRadar.oldMyStates.get(1).getPosition());
                w.enName = bot.name;
                w.isMeleeWave = others > 1;
                w.enState = bot.botStateLogs.get(1);
                w.myState = HeliosRadar.currentMyState;
                w.prevMyState = HeliosRadar.oldMyStates.get(1);
                w.direction = HUtils.sign(bot.myLatVel);
                w.myDirChangeTime = bot.myDirChangeTime;
                w.myDist10 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(11, HeliosRadar.oldMyStates.size() - 1)).getPosition());
                w.myDist16 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(17, HeliosRadar.oldMyStates.size() - 1)).getPosition());
                w.myDist30 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(31, HeliosRadar.oldMyStates.size() - 1)).getPosition());
                w.myDist60 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(61, HeliosRadar.oldMyStates.size() - 1)).getPosition());
                w.myDist120 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(121, HeliosRadar.oldMyStates.size() - 1)).getPosition());
                w.color = this.waveColor();
                if (tickWave != null && tickWave.tickBack != null) {
                    w.tickBack = tickWave.tickBack;
                    w.thisTickWave = tickWave;
                }
                if (bot.lastSurfWave != null) {
                    bot.lastSurfWave.next = w;
                    w.back = bot.lastSurfWave;
                }
                bot.lastSurfWave = w;
                this._waves.add(w);
                continue;
            }
            if (!((double)this._time > 2.7 / HConstants.GUN_COOLING_RATE) || !(bot.currentState.getPosition().distance(this._myPos) < 200.0) || !(bot.currentState.getEnergy() > 0.0)) continue;
            w = new Wave(bot.botStateLogs.get(1).getPosition());
            w.fireTime = (long)((double)(bot.lastScanTime + time) / 2.0) - 2L;
            w.rammerWave = true;
            w.bulletPower = HUtils.bulletPowerFromVelocity(8.0);
            w.directAngle = HUtils.absoluteBearing(bot.botStateLogs.get(1).getPosition(), HeliosRadar.oldMyStates.get(1).getPosition());
            w.enName = bot.name;
            w.isMeleeWave = others > 1;
            w.enState = bot.botStateLogs.get(1);
            w.myState = HeliosRadar.currentMyState;
            w.prevMyState = HeliosRadar.oldMyStates.get(1);
            w.direction = HUtils.sign(bot.myLatVel);
            w.myDirChangeTime = bot.myDirChangeTime;
            w.myDist10 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(11, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            w.myDist16 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(17, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            w.myDist30 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(31, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            w.myDist60 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(61, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            w.myDist120 = HeliosRadar.oldMyStates.get(1).getPosition().distance(HeliosRadar.oldMyStates.get(Math.min(121, HeliosRadar.oldMyStates.size() - 1)).getPosition());
            w.color = this.waveColor();
            this._waves.add(w);
        }
        this.updateWaves();
        this.doSurfing();
        this.pathTime = 0L;
        this.dangerTime = 0L;
        this.dangerCalled = 0;
        this.treeNodes = 0;
        this.cutNodes = 0;
        this.paint = true;
    }

    public void doSurfing() {
        Graphics2D g = this._robot.getGraphics();
        Wave surfWave = this.getClosestSurfableWave(this._waves, this._myPos);
        if (surfWave == null) {
            this.nonWaveMove.onTick();
        } else {
            RiskSet bestRiskSet = null;
            Path bestPath = null;
            PathPos bestPathPos = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            ArrayList<Path> paths = null;
            MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(this._myPos.x, this._myPos.y, this._robot.getHeadingRadians(), this._robot.getVelocity(), this._robot.getTime());
            long then = System.nanoTime();
            paths = this.currentPlanner.generatePath(status, surfWave);
            long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
            this.pathTime += millis;
            int depth = Math.min(MAX_SURF, this._waves.size());
            ArrayList<Wave> surfWaves = new ArrayList<Wave>();
            ArrayList wavesBin = (ArrayList)this._waves.clone();
            for (int i = 0; i < depth; ++i) {
                Wave w = this.getClosestSurfableWave(wavesBin, this._myPos);
                wavesBin.remove(w);
                surfWaves.add((Wave)w.clone());
            }
            double beforeMin = Double.POSITIVE_INFINITY;
            ArrayList<RiskSet> riskSetList = new ArrayList<RiskSet>();
            for (Path path : paths) {
                double risk = 0.0;
                PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                RiskSet result = this.dangerTree(surfWave, dest.status, surfWaves, -1, Double.POSITIVE_INFINITY);
                risk = result.risk;
                result.path = path;
                riskSetList.add(result);
            }
            Collections.sort(riskSetList);
            Collections.reverse(riskSetList);
            for (RiskSet riskSet : riskSetList) {
                Path path = riskSet.path;
                if (bestPath != null && bestRisk < riskSet.risk) {
                    ++this.cutNodes;
                    continue;
                }
                double risk = 0.0;
                PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                RiskSet result = this.dangerTree(surfWave, dest.status, surfWaves, depth, Double.POSITIVE_INFINITY);
                risk = result.risk;
                if (!(risk < bestRisk)) continue;
                bestRiskSet = result;
                bestPath = path;
                bestRisk = risk;
                bestPathPos = dest;
            }
            if (this.paint && bestRiskSet != null) {
                int rectSize = 18;
                Stroke cache = g.getStroke();
                g.setStroke(this.bs);
                Point2D.Double lastPos = this._myPos;
                PathPos dest = bestPath.path.get(Math.max(0, bestPath.path.size() - 1));
                for (PathPos pos : bestPath.path) {
                    g.setColor(Color.cyan);
                    if (pos.pathColor != null) {
                        g.setColor(pos.pathColor);
                    }
                    g.drawLine((int)lastPos.x, (int)lastPos.y, (int)pos.x, (int)pos.y);
                    lastPos = pos;
                }
                g.drawRect((int)(dest.x - (double)rectSize), (int)(dest.y - (double)rectSize), rectSize * 2, rectSize * 2);
                RiskSet riskSet = bestRiskSet;
                while (riskSet.deeper != null) {
                    for (PathPos pos : riskSet.path.path) {
                        g.setColor(Color.white);
                        if (pos.pathColor != null) {
                            g.setColor(pos.pathColor);
                        }
                        g.drawLine((int)lastPos.x, (int)lastPos.y, (int)pos.x, (int)pos.y);
                        lastPos = pos;
                    }
                    dest = riskSet.path.path.get(Math.max(0, riskSet.path.path.size() - 1));
                    g.drawRect((int)(dest.x - (double)rectSize), (int)(dest.y - (double)rectSize), rectSize * 2, rectSize * 2);
                    riskSet = riskSet.deeper;
                }
                g.setStroke(cache);
            }
            if (bestPathPos != null) {
                double ran = Math.random() / 1.0E12;
                if (bestPathPos.maxVelocity > 7.9) {
                    this._robot.setMaxVelocity(8.0 - ran);
                } else if (bestPathPos.maxVelocity < 1.0) {
                    this._robot.setMaxVelocity(ran);
                } else {
                    this._robot.setMaxVelocity(bestPathPos.maxVelocity - ran);
                }
                double absBearing = 0.0;
                if (this.currentPlanner instanceof DuelPlan || this.currentPlanner instanceof RamEscapePlan) {
                    absBearing = HUtils.absoluteBearing(this._myPos, bestPath.path.get((int)Math.min((int)1, (int)(bestPath.path.size() - 1))).status);
                    absBearing = this.wallSmoothing(this._myPos.x, this._myPos.y, absBearing, bestPathPos.status.direction, 1);
                } else {
                    absBearing = HUtils.absoluteBearing(this._myPos, bestPath.path.get((int)Math.min((int)1, (int)(bestPath.path.size() - 1))).status);
                    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
                    trig.sin = Math.sin(this._robot.getHeadingRadians());
                    trig.cos = Math.cos(this._robot.getHeadingRadians());
                    absBearing = HConstants.preciseWallSmooth.smoothHeading(absBearing, trig, this._myPos.x, this._myPos.y, HUtils.sign(this._robot.getVelocity()));
                }
                Surfing.setBackAsFront((AdvancedRobot)this._robot, absBearing);
                if (bestPathPos.maxVelocity < 1.0) {
                    this._robot.setAhead(100.0);
                }
            }
        }
    }

    public double wallSmoothing(double x, double y, double startAngle, int orientation, int smoothTowardEnemy) {
        double angle = startAngle;
        double testX = x + Math.sin(angle += Math.PI * 4) * (double)WALL_STICK;
        double testY = y + Math.cos(angle) * (double)WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, HConstants.fieldWidth - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, HConstants.fieldHeight - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, HConstants.fieldWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, HConstants.fieldHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!HConstants.safeField.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)(smoothTowardEnemy * orientation) * (Math.abs(Math.acos(adjacent / (double)WALL_STICK)) + 0.005)) * (double)WALL_STICK;
            testY = y + Math.cos(angle) * (double)WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, HConstants.fieldWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, HConstants.fieldHeight - testY - 18.0);
            if (smoothTowardEnemy != -1) continue;
        }
        return angle;
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public RiskSet dangerTree(Wave surfWave, MovementPredictor.PredictionStatus status, ArrayList<Wave> waves, int depth, double min) {
        ++this.treeNodes;
        double bandwidth = 36.0 / status.distance(surfWave);
        Intersection intersection = new Intersection(HUtils.absoluteBearing(surfWave, status), bandwidth);
        double risk = 0.0;
        double waveRisk = this.getDangerScore(surfWave, intersection);
        this.waveDangerSum += waveRisk;
        this.waveDangerCount += 1.0;
        if (HeliosRadar.getBot((String)surfWave.enName).nearestBotName.equals(this._myName)) {
            waveRisk *= 2.125;
        }
        double posRisk = this.getBotRisk(status);
        this.posDangerCount += 1.0;
        this.posDangerSum += posRisk;
        if (!surfWave.isMeleeWave) {
            posRisk /= 5.0;
            if (Double.isNaN(posRisk *= 0.0)) {
                posRisk = 0.0;
            }
            risk += posRisk / this.averagePosDanger + waveRisk / this.averageWaveDanger;
        } else {
            risk += posRisk / this.averagePosDanger + waveRisk / this.averageWaveDanger;
        }
        double currentDistanceToWaveSource = status.distance(surfWave);
        double currentDistanceToWave = currentDistanceToWaveSource - surfWave.distanceTraveled;
        double timeToImpact = Math.max(1.0, currentDistanceToWave / surfWave.bulletVelocity());
        risk /= timeToImpact;
        RiskSet bestSecondRiskSet = null;
        Path bestSecondPath = null;
        if (depth > 0 && waves.size() > 1) {
            double addDistance = status.distance(surfWave) - surfWave.distanceTraveled;
            waves.remove(surfWave);
            for (Wave w : waves) {
                w.distanceTraveled += addDistance;
            }
            Wave secondWave = this.getClosestSurfableWave(waves, status);
            if (secondWave != null) {
                long then = System.nanoTime();
                ArrayList<Path> paths = this.currentPlanner.generatePath(status, secondWave);
                long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
                this.pathTime += millis;
                double bestSecondRisk = Double.POSITIVE_INFINITY;
                if (depth > 100) {
                    ArrayList<RiskSet> riskSetList = new ArrayList<RiskSet>();
                    for (Path path : paths) {
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet result = this.dangerTree(secondWave, dest.status, waves, -1, Double.POSITIVE_INFINITY);
                        result.path = path;
                        riskSetList.add(result);
                    }
                    Collections.sort(riskSetList);
                    for (RiskSet riskSet : riskSetList) {
                        Path path = riskSet.path;
                        if (bestSecondPath != null && risk + bestSecondRisk < riskSet.risk) {
                            ++this.cutNodes;
                            continue;
                        }
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet res = this.dangerTree(secondWave, dest.status, waves, depth - 1, min);
                        double secondRisk = res.risk;
                        min = Math.min(min, risk);
                        if (!(secondRisk < bestSecondRisk)) continue;
                        bestSecondPath = path;
                        bestSecondRisk = secondRisk;
                        bestSecondRiskSet = res;
                    }
                } else {
                    for (Path path : paths) {
                        PathPos dest = path.path.get(Math.max(0, path.path.size() - 1));
                        RiskSet res = this.dangerTree(secondWave, dest.status, waves, depth - 1, min);
                        double secondRisk = res.risk;
                        min = Math.min(min, risk);
                        if (!(secondRisk < bestSecondRisk)) continue;
                        bestSecondPath = path;
                        bestSecondRisk = secondRisk;
                        bestSecondRiskSet = res;
                    }
                }
                risk += bestSecondRisk;
            }
            for (Wave w : waves) {
                w.distanceTraveled -= addDistance;
            }
            waves.add(surfWave);
        }
        RiskSet riskSet = new RiskSet(bestSecondPath, risk);
        riskSet.deeper = bestSecondRiskSet;
        return riskSet;
    }

    double getBotRisk(MovementPredictor.PredictionStatus status) {
        double risk = 0.0;
        for (Bot bot : HeliosRadar.enemies.values()) {
            if (!bot.alive) continue;
            double energyRatio = Math.min((bot.currentState.getEnergy() - 1.0) / this._myEnergy, 2.0);
            double distance = bot.currentState.getPosition().distance(status);
            double p = 1.0 + Math.abs(Math.cos(status.heading - HUtils.absoluteBearing(bot.currentState.getPosition(), status)));
            if (this._others > 1) {
                risk += energyRatio * p / (distance * distance);
                continue;
            }
            risk += energyRatio / distance * distance;
        }
        if (this._others > 1) {
            risk += 50.0 / this._centerPos.distanceSq(status);
        }
        return risk;
    }

    double getDangerScore(Wave w, Intersection intersection) {
        long then = System.nanoTime();
        double dangerAngle = intersection.angle;
        double bandwidth = intersection.bandwidth;
        double totalDanger = 0.0;
        double totalScanWeight = 0.0;
        int enabledSize = 0;
        for (TreeGFData nearestNeighbors : w.nearestNeighbors) {
            enabledSize += nearestNeighbors.nearestNeighbors.size();
            double density = 0.0;
            double viewScanWeight = 0.0;
            for (GFData gfData : nearestNeighbors.nearestNeighbors) {
                double decayWeight = 1.0 / Math.pow(gfData.decayRate, w.fireTime - gfData.time);
                double scanWeight = gfData.weight * gfData.treeWeight * decayWeight / Math.sqrt(gfData.distance + 1.0);
                double xFiringAngle = HUtils.normalizeAngle(w.firingAngle(gfData.guessFactor), dangerAngle);
                double ux = (xFiringAngle - dangerAngle) / bandwidth;
                density += scanWeight * Math.exp(-0.5 * (ux * ux));
                viewScanWeight += scanWeight;
            }
            totalScanWeight += viewScanWeight;
            totalDanger += density;
        }
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        this.dangerTime += millis;
        ++this.dangerCalled;
        if (enabledSize == 0) {
            return Rules.getBulletDamage((double)w.bulletPower) * Surfing.defaultDanger(w, intersection);
        }
        return Rules.getBulletDamage((double)w.bulletPower) * totalDanger / totalScanWeight;
    }

    private static double defaultDanger(Wave w, Intersection intersection) {
        double[] guessFactors = new double[]{-1.0, 0.0, 1.0};
        double[] weights = new double[]{1.0, 10.0, 5.0};
        double danger = 0.0;
        for (int x = 0; x < guessFactors.length; ++x) {
            double firingAngle = w.firingAngle(guessFactors[x]);
            double ux = (firingAngle - HUtils.normalizeAngle(intersection.angle, firingAngle)) / intersection.bandwidth;
            danger += weights[x] * Math.pow(2.0, -Math.abs(ux));
        }
        return danger;
    }

    public void updateWaves() {
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (int x = 0; x < this._waves.size(); ++x) {
            Wave ew = this._waves.get(x);
            Bot bot = HeliosRadar.enemies.get(ew.enName);
            ++ew.ramTimeCount;
            ew.distanceTraveled = (double)(time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > this._myPos.distance(ew) + ew.bulletVelocity() * 2.0) {
                if (ew.isMeleeWave) {
                    // empty if block
                }
                HeliosRadar.currentMyState.currentGF = ew.guessFactor(HeliosRadar.currentMyState.getPosition());
                this._waves.remove(x);
                --x;
                continue;
            }
            if (ew.rammerWave && ew.ramTimeCount > 1) {
                this._waves.remove(x);
                --x;
                continue;
            }
            boolean empty = true;
            if (ew.nearestNeighbors != null) {
                for (TreeGFData gfData : ew.nearestNeighbors) {
                    if (gfData.nearestNeighbors.isEmpty()) continue;
                    empty = false;
                    break;
                }
            }
            if (ew.nearestNeighbors != null && !ew.nearestNeighbors.isEmpty() && !empty) continue;
            ew.nearestNeighbors = others <= 1 ? bot.getNearestNeighborsList(ew, bot.surfModels) : bot.getNearestNeighborsList(ew, bot.meleeSurfModels);
        }
    }

    public void updateTickWaves() {
        long time = this._robot.getTime();
        int others = this._robot.getOthers();
        for (int x = 0; x < this._tickWaves.size(); ++x) {
            Wave ew = this._tickWaves.get(x);
            Bot bot = HeliosRadar.enemies.get(ew.enName);
            ++ew.ramTimeCount;
            ew.distanceTraveled = (double)(time - ew.fireTime) * ew.bulletVelocity();
            if (ew.distanceTraveled > this._myPos.distance(ew) + ew.bulletVelocity() * 2.0) {
                if (ew.isMeleeWave) {
                    // empty if block
                }
                HeliosRadar.currentMyState.currentGF = ew.guessFactor(HeliosRadar.currentMyState.getPosition());
                this._tickWaves.remove(x);
                --x;
                continue;
            }
            if (!ew.rammerWave || ew.ramTimeCount <= 1) continue;
            this._tickWaves.remove(x);
            --x;
        }
    }

    public Wave getClosestSurfableWave(ArrayList<Wave> waves, Point2D.Double pos) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Wave surfWave = null;
        if (waves.isEmpty()) {
            return null;
        }
        if (waves.size() == 1) {
            return waves.get(0);
        }
        for (Wave ew : waves) {
            double distance;
            if (surfWave == null) {
                surfWave = ew;
            }
            if (!((distance = (pos.distance(ew) - ew.distanceTraveled) / ew.bulletVelocity()) > -ew.bulletVelocity()) || !(distance < closestDistance)) continue;
            surfWave = ew;
            closestDistance = distance;
        }
        return surfWave;
    }

    public void logHit(Wave ew, Point2D.Double targetLocation) {
        long time = this._robot.getTime();
        Bot bot = HeliosRadar.getBot(ew.enName);
        GFData data = new GFData();
        data.guessFactor = ew.guessFactor(targetLocation);
        data.weight = 1.0;
        data.treeWeight = 1.0;
        data.time = time;
        if (ew.isMeleeWave) {
            bot.addData(ew, data, bot.meleeSurfModels);
        } else {
            bot.addData(ew, data, bot.surfModels);
        }
    }

    public void onRoundEnded() {
        System.out.println();
        System.out.println("***** surfing *****");
        System.out.println("duel hit rate: " + 100.0 * (duelHitCount / duelFiredCount) + "%");
        System.out.println("melee hit rate: " + 100.0 * (meleeHitCount / meleeFiredCount) + "%");
        System.out.println();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bot bot = HeliosRadar.getBot(e.getName());
        if (bot != null && bot.alive && bot.botStateLogs.size() > 2) {
            bot.botStateLogs.get(1).setEnergy(bot.botStateLogs.get(1).getEnergy() + Rules.getBulletHitBonus((double)e.getBullet().getPower()));
        }
        if (this._robot.getOthers() <= 1) {
            duelHitCount += 1.0;
        } else {
            meleeHitCount += 1.0;
        }
        if (!this._waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._waves.size(); ++x) {
                Wave ew = this._waves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ew.bulletVelocity()) < 0.001 && Objects.equals(e.getBullet().getName(), ew.enName)) {
                    hitWave = ew;
                    break;
                }
                if (!(this._myPos.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = this._myPos.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onHitByBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this._waves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Wave hitWave = null;
            Wave nearestWave = null;
            double bestDist = Double.POSITIVE_INFINITY;
            double bestScore = Double.POSITIVE_INFINITY;
            for (int x = 0; x < this._waves.size(); ++x) {
                Wave ew = this._waves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew)) < bestScore && e.getHitBullet().getName().equals(ew.enName)) {
                    hitWave = ew;
                    bestScore = Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew));
                }
                if (!(this._myPos.distance(ew) - ew.distanceTraveled < bestDist)) continue;
                nearestWave = ew;
                bestDist = this._myPos.distance(ew) - ew.distanceTraveled;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
            } else if (nearestWave != null) {
                this.logHit(nearestWave, hitBulletLocation);
                System.out.println("\"onBulletHitBullet\" to log the nearest Wave instead.");
            }
        }
    }

    public void onPaint(Graphics2D g) {
        this.oldPaint = this.paint;
        this.paint = true;
        int numBins = 41;
        double halfBins = (double)(numBins - 1) / 2.0;
        double[] gfDangers = new double[numBins];
        double[] gfShadowed = new double[numBins];
        Intersection intersection = new Intersection(0.0, 0.0);
        Point2D.Double dangerLocation = new Point2D.Double();
        Point2D.Double oldDrawLocation = new Point2D.Double();
        Point2D.Double drawLocation = new Point2D.Double();
        Point2D.Double drawLocationBuffer = null;
        for (Wave enemyWave : this._waves) {
            double bearingOffset;
            double gf;
            int x;
            g.setColor(Color.red);
            if (enemyWave.color != null) {
                g.setColor(enemyWave.color);
            }
            int radius = (int)enemyWave.distanceTraveled;
            g.drawOval((int)(enemyWave.x - (double)radius), (int)(enemyWave.y - (double)radius), radius * 2, radius * 2);
            double minDanger = Double.POSITIVE_INFINITY;
            double maxDanger = Double.NEGATIVE_INFINITY;
            double maxPointDanger = Double.NEGATIVE_INFINITY;
            Point2D.Double maxDangerPos = null;
            for (x = 0; x <= numBins - 1; ++x) {
                gf = ((double)x - halfBins) / halfBins;
                bearingOffset = (double)enemyWave.direction * (gf * HUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
                double absFiringAngle = enemyWave.directAngle + bearingOffset;
                HUtils.projectWithCache(enemyWave, absFiringAngle, enemyWave.distanceTraveled + enemyWave.bulletVelocity(), dangerLocation);
                intersection = new Intersection(HUtils.absoluteBearing(enemyWave, dangerLocation), 36.0 / enemyWave.distance(dangerLocation));
                if (enemyWave.nearestNeighbors != null) {
                    gfDangers[x] = this.getDangerScore(enemyWave, intersection);
                }
                if (gfDangers[x] < minDanger) {
                    minDanger = gfDangers[x];
                }
                if (!(gfDangers[x] > maxDanger)) continue;
                maxDanger = gfDangers[x];
                maxDangerPos = dangerLocation;
            }
            for (x = 0; x <= numBins - 1; ++x) {
                gf = ((double)x - halfBins) / halfBins;
                bearingOffset = (double)enemyWave.direction * (gf * HUtils.maxEscapeAngle(enemyWave.bulletVelocity()));
                HUtils.projectWithCache(enemyWave, enemyWave.directAngle + bearingOffset, enemyWave.distanceTraveled - 10.0 + enemyWave.bulletVelocity(), drawLocation);
                if (maxPointDanger < gfDangers[x]) {
                    maxPointDanger = gfDangers[x];
                    maxDangerPos = new Point2D.Double(drawLocation.x, drawLocation.y);
                }
                Color binColor = this.getColorForHitRate(gfDangers[x] / maxDanger);
                g.setColor(binColor);
                if (oldDrawLocation != null && x > 0) {
                    Stroke cache = g.getStroke();
                    g.setStroke(this.bs);
                    g.drawLine((int)oldDrawLocation.x, (int)oldDrawLocation.y, (int)drawLocation.x, (int)drawLocation.y);
                    g.setStroke(cache);
                } else {
                    g.fillOval((int)drawLocation.x - 2, (int)drawLocation.y - 2, 4, 4);
                }
                drawLocationBuffer = oldDrawLocation;
                oldDrawLocation = drawLocation;
                drawLocation = drawLocationBuffer;
            }
        }
    }

    public Color getColorForHitRate(double d) {
        double colorAmp = 0.7;
        return new Color(Color.HSBtoRGB((float)(0.7 - Math.min(0.7, colorAmp * d)), 1.0f, 1.0f));
    }

    public static class RiskSet
    implements Comparable<RiskSet> {
        public Path path;
        public double risk;
        public RiskSet deeper;

        public RiskSet(Path path, double risk) {
            this.path = path;
            this.risk = risk;
        }

        @Override
        public int compareTo(RiskSet o) {
            return (int)Math.signum(this.risk - o.risk);
        }
    }
}

