/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.robot;

import catcat20.helios.gun.Gun;
import catcat20.helios.gun.HeliosGun;
import catcat20.helios.gun.pif.PIFData;
import catcat20.helios.move.models.GeneticModel;
import catcat20.helios.move.models.Simple2Model;
import catcat20.helios.move.models.Simple3Model;
import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.robot.BotState;
import catcat20.helios.utils.HConstants;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.Wave;
import catcat20.helios.utils.knn.GFData;
import catcat20.helios.utils.knn.KNNData;
import catcat20.helios.utils.knn.KNNModel;
import catcat20.helios.utils.knn.TreeGFData;
import catcat20.helios.utils.knn.WaveKNNModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;

public class Bot {
    public boolean alive = true;
    public String name;
    public long lastScanTime;
    public ArrayList<BotState> botStateLogs;
    public BotState currentState;
    private BotState lastState;
    public double myDirChangeTime;
    public double dirChangeTime;
    public double velChangeTime;
    public double timeSinceDecelTime;
    public double oldLatVel;
    public double latVel;
    public double oldAdvVel;
    public double advVel;
    public double myLatVel;
    public boolean canFire = true;
    public double gunHeat = 30.0 * HConstants.GUN_COOLING_RATE;
    private final KNNModel<Double> bulletPowerPredictor;
    public ArrayList<WaveKNNModel> surfModels;
    public ArrayList<WaveKNNModel> meleeSurfModels;
    public PIFData lastPIFData;
    public KNNModel<PIFData> pifModel;
    public KNNModel<PIFData> meleePifModel;
    public double[] lastPatternDataPoint = null;
    public double[] lastMeleePatternDataPoint = null;
    public KNNModel<PIFData> patternModel;
    public KNNModel<PIFData> meleePatternModel;
    public String nearestBotName;
    public Wave lastSurfWave;
    public Wave lastSurfTickWave;
    public KNNModel<GFData> antiSurferGunModel;
    public KNNModel<GFData> guessFactorGunModel;
    public HashMap<Gun, GunCount> gunHitCount;

    public Bot() {
        double[] gfWeights = new double[]{10.094073753592324, 6.98972435954736, 8.061276816438141, 0.3418655187445476, 0.3174227433756247, 8.721939737416037, 4.004981116653366};
        this.guessFactorGunModel = new KNNModel(gfWeights);
        double[] asWeights = new double[]{10.713925220588484, 2.180942855917877, 2.495694703498005, 5.497528337267813, 0.9879555727156668, 7.96987995371324, 6.120225139268232};
        this.antiSurferGunModel = new KNNModel(asWeights);
        this.gunHitCount = new HashMap();
        for (Gun gun : HeliosGun.guns) {
            this.gunHitCount.put(gun, new GunCount());
        }
        this.botStateLogs = new ArrayList();
        this.bulletPowerPredictor = new KNNModel(new double[]{2.0, 1.0, 3.0, 10.0});
        double[] pifWeights = new double[]{8.0, 2.0, 6.0, 4.0, 3.0, 8.0, 6.0, 6.0, 6.0, 10.0, 8.0, 8.0, 8.0, 8.0};
        this.pifModel = new KNNModel(pifWeights);
        this.meleePifModel = new KNNModel(pifWeights);
        double[] tickPatternWeights = new double[]{8.0, 0.0, 0.0, 0.0, 2.0, 6.0, 0.0, 2.0, 2.0, 2.0, 3.0, 3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        double[] patternWeights = new double[tickPatternWeights.length * 30];
        for (int i = 0; i < 30; ++i) {
            for (int j = 0; j < tickPatternWeights.length; ++j) {
                patternWeights[i * tickPatternWeights.length + j] = tickPatternWeights[j];
            }
        }
        this.patternModel = new KNNModel(patternWeights);
        this.meleePatternModel = new KNNModel(patternWeights);
        this.surfModels = new ArrayList();
        this.surfModels.addAll(this.getSurfModels());
        this.meleeSurfModels = new ArrayList();
        this.meleeSurfModels.addAll(this.getMeleeSurfModels());
    }

    public void addData(Wave w, GFData data, ArrayList<WaveKNNModel> models) {
        for (WaveKNNModel model : models) {
            model.addPoint(w, data);
        }
    }

    public ArrayList<TreeGFData> getNearestNeighborsList(Wave w, ArrayList<WaveKNNModel> models) {
        ArrayList<TreeGFData> dataList = new ArrayList<TreeGFData>();
        for (WaveKNNModel model : models) {
            dataList.add(new TreeGFData(model, model.getNearestNeighborsList(w)));
        }
        return dataList;
    }

    public ArrayList<WaveKNNModel> getSurfModels() {
        ArrayList<WaveKNNModel> models = new ArrayList<WaveKNNModel>();
        models.add(new WaveKNNModel(new Simple2Model()).setKSize(15).setKDivisor(3).setTreeWeight(15));
        models.add(new WaveKNNModel(new Simple3Model()).setKSize(15).setKDivisor(2).setTreeWeight(15));
        models.add(new WaveKNNModel(new GeneticModel()).setKSize(15).setKDivisor(3).setTreeWeight(20));
        return models;
    }

    public ArrayList<WaveKNNModel> getMeleeSurfModels() {
        ArrayList<WaveKNNModel> models = new ArrayList<WaveKNNModel>();
        return models;
    }

    public void tickUpdate(TeamRobot robot) {
        BotState myState;
        Point2D.Double myPos = new Point2D.Double(robot.getX(), robot.getY());
        this.gunHeat -= HConstants.GUN_COOLING_RATE;
        if (this.gunHeat <= HConstants.GUN_COOLING_RATE) {
            this.canFire = true;
            double defaultPower = robot.getOthers() > 1 ? 3.0 : 1.95;
            this.gunHeat = Rules.getGunHeat((double)this.predictNextPower(robot, defaultPower)) - HConstants.GUN_COOLING_RATE;
        }
        if (this.currentState != null && !this.currentState.isRealData) {
            try {
                this.currentState = this.currentState.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            this.currentState.setPosition(this.currentState.interpolateNextPos());
            this.currentState.isRealData = false;
        }
        if (!this.botStateLogs.isEmpty()) {
            long time = robot.getTime();
            double energyDrop = this.botStateLogs.get(0).getEnergy() - this.currentState.getEnergy();
            if (energyDrop > 0.0 && energyDrop <= 3.01) {
                this.bulletPowerPredictor.addPoint(this.predictEnergyDataPoint(robot), energyDrop);
            }
        }
        this.currentState.dirChangeTime = this.dirChangeTime;
        this.botStateLogs.add(0, this.currentState);
        if (this.lastState != null) {
            this.lastState.next = this.currentState;
            this.currentState.back = this.lastState;
        }
        this.lastState = this.currentState;
        this.dirChangeTime += 1.0;
        if (HUtils.sign(this.oldLatVel) != HUtils.sign(this.latVel)) {
            this.dirChangeTime = 0.0;
        }
        this.velChangeTime += 1.0;
        if (this.currentState.getVelocity() != this.currentState.lastVel) {
            this.velChangeTime = 0.0;
        }
        this.timeSinceDecelTime += 1.0;
        if (Math.abs(this.currentState.getVelocity()) < Math.abs(this.currentState.lastVel)) {
            this.timeSinceDecelTime = 0.0;
        }
        if (this.currentState != null) {
            String myName = robot.getName();
            double nearestDist = this.currentState.getPosition().distance(myPos);
            this.nearestBotName = myName;
            for (Bot bot : HeliosRadar.enemies.values()) {
                double dist;
                BotState state;
                if (!bot.alive || bot.name.equals(this.name) || (state = bot.currentState) == null || !((dist = state.getPosition().distance(this.currentState.getPosition())) < nearestDist)) continue;
                nearestDist = dist;
                this.nearestBotName = bot.name;
            }
        }
        if ((myState = HeliosRadar.currentMyState) != null && this.currentState != null && HeliosRadar.oldMyStates.size() > 2) {
            double absBearing = HUtils.absoluteBearing(this.currentState.getPosition(), HeliosRadar.oldMyStates.get(2).getPosition());
            double latVel = myState.getVelocity() * Math.sin(myState.getHeading() - absBearing);
            double oldLatVel = HeliosRadar.oldMyStates.get(2).getVelocity() * Math.sin(myState.getHeading() - absBearing);
            this.myLatVel = latVel;
            this.myDirChangeTime += 1.0;
            if (HUtils.sign(oldLatVel) != HUtils.sign(latVel)) {
                this.myDirChangeTime = 0.0;
            }
        }
    }

    public void scannedUpdate(TeamRobot robot, ScannedRobotEvent e) {
        Point2D.Double myPos = new Point2D.Double(robot.getX(), robot.getY());
        Point2D.Double pos = HUtils.project(myPos, robot.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        BotState currentState = new BotState(e.getTime(), e.getEnergy(), pos, e.getVelocity(), e.getHeadingRadians());
        currentState.isRealData = true;
        this.name = e.getName();
        double absBearing = HUtils.absoluteBearing(myPos, pos);
        double latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
        double advVel = e.getVelocity() * -Math.cos(e.getHeadingRadians() - absBearing);
        this.latVel = latVel;
        this.advVel = advVel;
        if (this.currentState != null) {
            this.oldLatVel = this.currentState.latVel;
            this.oldAdvVel = this.currentState.advVel;
            currentState.lastVel = this.currentState.getVelocity();
        }
        currentState.latVel = latVel;
        currentState.advVel = advVel;
        this.currentState = currentState;
    }

    public double[] predictEnergyDataPoint(TeamRobot robot) {
        return new double[]{robot.getEnergy() / 120.0, this.currentState.getEnergy() / 120.0, this.currentState.getPosition().distance(robot.getX(), robot.getY()), robot.getOthers()};
    }

    public double predictNextPower(TeamRobot robot, double defaultPower) {
        ArrayList<KNNData<Double>> predictedPowers = this.bulletPowerPredictor.getNearestNeighborsList(this.predictEnergyDataPoint(robot), 1);
        if (predictedPowers != null && !predictedPowers.isEmpty()) {
            return (Double)predictedPowers.get((int)0).data;
        }
        return defaultPower;
    }

    public static class GunCount {
        public double hitCount;
        public double shotCount;
    }
}

