/*
 * Decompiled with CFR 0.152.
 */
package drm.parts;

import drm.common3.Brain;
import drm.common3.Coordinate;
import drm.common3.Driver;
import drm.common3.Enemy;
import drm.common3.EnemyStore;
import drm.common3.Gun;
import drm.common3.Mech;
import drm.common3.Motor;
import drm.common3.Radar;
import drm.common3.Utils;
import drm.parts.AssaultDriver;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ShadowDriver
extends Driver {
    static final double DRIVER_CHANGE_DAMAGE_RATE = 2.0;
    static final int WALLHITCOUNT_MAX = 3;
    static final int STOPCOUNT_MAX = 50;
    double maxOwnArea;
    Radar radar;
    Motor motor;
    Gun gun;
    boolean shadowInit;
    boolean initFlg1;
    boolean initFlg2;
    boolean initFlg3;
    double rotateRate;
    int count;
    Enemy prevEnemy;
    double firstMyEnergy;
    double firstEnemyEnergy;
    int thMax;
    int thrMax;
    int wallHitCount;
    int stopCount;
    boolean restoreFlg;
    Random random;

    public void init() {
        if (this.getMechas() != null) {
            this.radar = (Radar)this.getMech(0);
            this.motor = (Motor)this.getMech(1);
            this.gun = (Gun)this.getMech(2);
        }
    }

    public void initialize() {
        super.initialize();
        this.maxOwnArea = this.getAdvancedRobot().getBattleFieldHeight() / (double)4;
        if (this.maxOwnArea < this.getAdvancedRobot().getBattleFieldWidth() / (double)4) {
            this.maxOwnArea = this.getAdvancedRobot().getBattleFieldWidth() / (double)4;
        }
        this.motor.setSpeed(0.0);
        this.gun.setBulletPower(1.0);
    }

    public void move() {
        super.move();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0 && enemy.getNewEnemyInfo().heading != -99999.0 && enemy.getNewEnemyInfo().velocity != -99999.0 && enemy.getNewEnemyInfo().distance != -99999.0 && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
                this.aim(enemy);
                if (this.prevEnemy != enemy) {
                    this.shadowInit = false;
                    this.initFlg1 = true;
                    this.initFlg2 = true;
                    this.count = 0;
                }
                if (!this.shadowInit) {
                    this.shadowInit = this.shadowInitMove(enemy);
                } else {
                    this.shadowMove(enemy);
                }
            }
        } else {
            this.aimCancel();
        }
        this.prevEnemy = enemy;
        this.changeDriver();
    }

    void changeDriver() {
        Enemy enemy;
        if (this.restoreFlg) {
            this.setNextDriver(new AssaultDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
        }
        if (this.getAdvancedRobot().getOthers() == 1 && (enemy = this.getBrain().getTarget()) != null) {
            if (this.firstMyEnergy == 0.0) {
                this.firstMyEnergy = this.getAdvancedRobot().getEnergy();
            }
            if (this.firstEnemyEnergy == 0.0) {
                this.firstEnemyEnergy = enemy.getNewEnemyInfo().energy;
            }
            double myDamage = this.firstMyEnergy - this.getAdvancedRobot().getEnergy();
            double enemyDamage = this.firstEnemyEnergy - enemy.getNewEnemyInfo().energy;
            if (enemyDamage == 0.0) {
                return;
            }
            double damageRate = myDamage / this.firstMyEnergy;
            double damageCompareRate = myDamage / enemyDamage;
            if (damageCompareRate > (double)2 && damageRate > 0.5) {
                this.setNextDriver(new AssaultDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
            }
        }
    }

    boolean shadowInitMove(Enemy enemy) {
        EnemyStore es = enemy.getNewEnemyInfo();
        boolean ret = false;
        double th = this.thMax;
        double thr = this.thrMax;
        double x = this.getAdvancedRobot().getBattleFieldWidth() - es.x;
        double y = this.getAdvancedRobot().getBattleFieldHeight() - es.y;
        double heading = es.heading + 180.0;
        if (this.initFlg2 || Math.abs(this.getAdvancedRobot().getX() - x) < th && Math.abs(this.getAdvancedRobot().getY() - y) < th) {
            this.initFlg2 = true;
            this.motor.setSpeed(1.0);
            if (Math.abs(Utils.normalRelativeAngle(this.getAdvancedRobot().getHeading() - heading)) < thr) {
                System.out.println("Init ok.");
                ret = true;
            } else {
                if (!this.initFlg3) {
                    if (Utils.normalRelativeAngle(heading - this.getAdvancedRobot().getHeading()) < 0.0) {
                        this.rotateRate = -1.0;
                    }
                    this.initFlg3 = true;
                }
                this.motor.setTurn(Utils.normalRelativeAngle(heading - this.getAdvancedRobot().getHeading()));
            }
        } else {
            double bearing = Utils.calcRelativeBearing(this.getAdvancedRobot().getHeading(), this.getAdvancedRobot().getX(), this.getAdvancedRobot().getY(), x, y);
            this.motor.setTurn(bearing);
            if (Math.abs(bearing) < thr) {
                this.initFlg1 = true;
            }
            if (this.initFlg1) {
                this.motor.setSpeed(8.0);
            }
            if (this.count > 100) {
                this.initFlg2 = true;
                System.out.println("Time out.");
            }
            ++this.count;
        }
        return ret;
    }

    void shadowMove(Enemy enemy) {
        EnemyStore es = enemy.getNewEnemyInfo();
        EnemyStore pes = null;
        int eslen = enemy.enemyStoreList.size();
        if (eslen > 1) {
            pes = (EnemyStore)enemy.enemyStoreList.elementAt(eslen - 2);
            this.motor.setTurn(Utils.normalRelativeAngle(es.heading - pes.heading));
        }
        double sp = this.motor.getSpeed();
        double deg = this.getAdvancedRobot().getHeading();
        if (sp < 0.0) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (Utils.chkOutOfBattleField(deg, 100.0, (Robot)this.getAdvancedRobot())) {
            this.motor.setSpeed(es.velocity / (double)5);
        } else {
            this.motor.setSpeed(es.velocity);
        }
        if (Math.abs(es.velocity) < 0.5) {
            ++this.stopCount;
            if (this.stopCount >= 50) {
                this.restoreFlg = true;
            }
        } else {
            this.stopCount = 0;
        }
    }

    void aim(Enemy enemy) {
        double x = enemy.getNewEnemyInfo().x;
        double y = enemy.getNewEnemyInfo().y;
        double bulletPower = Math.min((double)3, Utils.getBulletPowerToKill(enemy.getNewEnemyInfo().energy));
        double myEnergy = this.getAdvancedRobot().getEnergy();
        if (myEnergy < bulletPower) {
            bulletPower = 0.1;
        }
        Coordinate impactPoint = null;
        impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(enemy, enemy, this.getBrain().myStoreList, bulletPower);
        if (impactPoint == null && Brain.enemyListBak != null) {
            Enemy prevRoundEnemy = (Enemy)Brain.enemyListBak.get(enemy.name);
            impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(prevRoundEnemy, enemy, Brain.myStoreListBak, bulletPower);
            boolean bl = false;
            if (impactPoint != null) {
                bl = true;
            }
        }
        if (impactPoint == null) {
            impactPoint = this.getBrain().getCircuitEnemyImpactPoint(enemy, bulletPower);
            if (this.random.nextDouble() < 0.5) {
                double mx = this.getAdvancedRobot().getX();
                double my = this.getAdvancedRobot().getY();
                double delta = enemy.deltaShoot / Utils.getBulletVelocity(bulletPower) * Utils.calcDistance(mx, my, x, y);
                if (Utils.normalRelativeAngle(Utils.calcAbsoluteBearing(mx, my, x, y) - Utils.calcAbsoluteBearing(mx, my, impactPoint.x, impactPoint.y)) < 0.0) {
                    delta = -delta;
                }
                this.gun.setDelta(delta);
            } else {
                this.gun.setDelta(0.0);
            }
        } else {
            this.gun.setDelta(0.0);
        }
        if (enemy.getNewEnemyInfo().energy != 0.0 && myEnergy < 1.0) {
            impactPoint = null;
        }
        this.gun.setBulletPower(bulletPower);
        this.radar.setTargetPoint(x, y);
        if (impactPoint != null && impactPoint.x > 0.0 && impactPoint.x < this.getAdvancedRobot().getBattleFieldWidth() && impactPoint.y > 0.0 && impactPoint.y < this.getAdvancedRobot().getBattleFieldHeight()) {
            this.gun.setTargetPoint(impactPoint.x, impactPoint.y);
        }
    }

    void aimCancel() {
        this.radar.resetTargetPoint();
        this.motor.resetTargetPoint();
        this.gun.resetTargetPoint();
    }

    public double getMaxOwnArea() {
        return this.maxOwnArea;
    }

    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        super.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        super.onBulletMissed(e);
    }

    public void onDeath(DeathEvent e) {
        super.onDeath(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        super.onHitByBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
    }

    public void onHitWall(HitWallEvent e) {
        super.onHitWall(e);
        ++this.wallHitCount;
        if (this.wallHitCount >= 3) {
            this.restoreFlg = true;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        super.onRobotDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
    }

    public void onWin(WinEvent e) {
        super.onWin(e);
        this.motor.setSpeed(0.0);
    }

    private final /* synthetic */ void this() {
        this.shadowInit = false;
        this.initFlg1 = true;
        this.initFlg2 = true;
        this.initFlg3 = false;
        this.rotateRate = 0.0;
        this.count = 0;
        this.prevEnemy = null;
        this.firstMyEnergy = 0.0;
        this.firstEnemyEnergy = 0.0;
        this.thMax = 5;
        this.thrMax = 5;
        this.wallHitCount = 0;
        this.stopCount = 0;
        this.restoreFlg = false;
        this.random = new Random();
    }

    public ShadowDriver() {
        this.this();
        this.init();
    }

    public ShadowDriver(AdvancedRobot r) {
        super(r);
        this.this();
        this.init();
    }

    public ShadowDriver(AdvancedRobot r, Mech[] m) {
        super(r, m);
        this.this();
        this.init();
    }

    public ShadowDriver(AdvancedRobot r, Mech[] m, Brain b) {
        super(r, m, b);
        this.this();
        this.init();
    }
}

