/*
 * Decompiled with CFR 0.152.
 */
package jaybot.intel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jaybot.bots.BaseBot;
import jaybot.guns.FiringSolution;
import jaybot.intel.Enemy;
import jaybot.intel.RunningStatsBase;
import jaybot.intel.RunningStatsTracker;
import jaybot.strategies.ReactionEvents;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class EnemyIntel
extends RunningStatsBase
implements RunningStatsTracker {
    protected BaseBot myBot;
    private int _$2259;
    private Map _$2260 = new HashMap();
    private Map _$2261 = new HashMap();
    private int _$2262 = 0;
    private int _$2263 = 0;
    private int _$1652 = 0;
    private int[] _$2264 = new int[9];

    public void announceTracker() {
        this.myBot.logImportant(this.getClass().getName() + " is now the current enemy tracker");
    }

    public void resetRunningStats(boolean collisions, boolean damageTaken, boolean shotStats) {
        super.resetRunningStats(collisions, damageTaken, shotStats);
        Iterator i = this.getAllEnemies().iterator();
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            badGuy.resetRunningStats(collisions, damageTaken, shotStats);
        }
    }

    public Collection getAliveEnemies() {
        ArrayList allEnemies = new ArrayList();
        allEnemies.addAll(this._$2260.values());
        return allEnemies;
    }

    public Collection getAllEnemies() {
        ArrayList allEnemies = new ArrayList();
        allEnemies.addAll(this._$2260.values());
        allEnemies.addAll(this._$2261.values());
        return allEnemies;
    }

    public Collection getDeadEnemies() {
        ArrayList allEnemies = new ArrayList();
        allEnemies.addAll(this._$2261.values());
        return allEnemies;
    }

    public void announceStats() {
        ArrayList allEnemies = new ArrayList();
        allEnemies.addAll(this._$2260.values());
        allEnemies.addAll(this._$2261.values());
        Iterator i = allEnemies.iterator();
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            badGuy.announceStats();
        }
    }

    public void setBot(BaseBot gaurdianship) {
        this.myBot = gaurdianship;
    }

    public BaseBot getBot() {
        return this.myBot;
    }

    public void setInitialEnemyCount(int initialCount) {
        this._$2259 = initialCount;
    }

    public void copyFromLastTracker(EnemyIntel lastTracker) {
    }

    public Enemy findEnemy(String name) {
        Enemy badGuy = (Enemy)this._$2260.get(name);
        if (badGuy == null) {
            badGuy = (Enemy)this._$2261.get(name);
        }
        if (badGuy == null) {
            badGuy = new Enemy(this, name);
            this._$2260.put(name, badGuy);
        }
        return badGuy;
    }

    public void recordFiringOfBullet(FiringSolution solution, Bullet firedBullet) {
        if (solution.getTargetName() != null) {
            Enemy badGuy = this.findEnemy(solution.getTargetName());
            badGuy.shootAt(solution, firedBullet);
        }
        ++this.runningShotsFired;
    }

    public void recordBulletHitTarget(BulletHitEvent event, ReactionEvents delegate) {
        Iterator i = this._$2260.values().iterator();
        double damage = BaseBot.getBulletDamageFromPower(event.getBullet().getPower());
        this.runningDamageToOthers += damage;
        ++this.runningShotsHitOthers;
        Enemy intendedTarget = null;
        Enemy actualTarget = null;
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            if (badGuy.isTargetOfBullet(event.getBullet())) {
                intendedTarget = badGuy;
            }
            badGuy.checkShotDueToHitATarget(event.getBullet(), damage);
            if (!badGuy.name.equals(event.getName())) continue;
            badGuy.registerDataFromEvent((Event)event);
            actualTarget = badGuy;
        }
        delegate.reactToBulletHitTarget(event, actualTarget, intendedTarget);
    }

    public void recordBulletMissedTarget(BulletMissedEvent event, ReactionEvents delegate) {
        Iterator i = this._$2260.values().iterator();
        Enemy intendedTarget = null;
        ++this.runningShotsMissedOthers;
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            if (!badGuy.checkShotDueToMissAllTargets(event.getBullet())) continue;
            intendedTarget = badGuy;
        }
        delegate.reactToBulletMissedTarget(event, intendedTarget);
    }

    public void recordBulletHitAnotherBullet(BulletHitBulletEvent event, ReactionEvents delegate) {
        Iterator i = this._$2260.values().iterator();
        Enemy intendedTarget = null;
        while (i.hasNext()) {
            Enemy badGuy = (Enemy)i.next();
            if (!badGuy.checkShotDueToMissFromInterception(event.getBullet())) continue;
            intendedTarget = badGuy;
        }
        Enemy actualTarget = this.findEnemy(event.getHitBullet().getName());
        delegate.reactToBulletHitAnotherBullet(event, intendedTarget, actualTarget);
    }

    public void recordYouHitByEnemyBullet(HitByBulletEvent event, ReactionEvents delegate) {
        Enemy badGuy = this.findEnemy(event.getName());
        double dmg = BaseBot.getBulletDamageFromPower(event.getBullet().getPower());
        this.runningDamageToMe += dmg;
        ++this.runningShotsHittingMe;
        badGuy.countBadGuyPickingOnMe(event.getBullet(), dmg);
        badGuy.registerDataFromEvent((Event)event);
        delegate.reactToYouHitByEnemyBullet(event, badGuy);
    }

    public void recordYouCollidedWithEnemyRobot(HitRobotEvent event, ReactionEvents delegate) {
        Enemy badGuy = this.findEnemy(event.getName());
        badGuy.countBadGuyCollidingWithMe(event);
        badGuy.registerDataFromEvent((Event)event);
        ++this.runningCollisions;
        delegate.reactToYouCollidedWithEnemyRobot(event, badGuy);
    }

    public void recordAnotherRobotDeath(RobotDeathEvent event, ReactionEvents delegate) {
        Enemy badGuy = this.findEnemy(event.getName());
        if (this._$2260.containsKey(event.getName())) {
            this._$2261.put(badGuy.name, badGuy);
            this._$2260.remove(badGuy.name);
        }
        badGuy.registerDataFromEvent((Event)event);
        ++this._$2262;
        this.myBot.logImportant("Death[" + this._$2262 + "] of: " + badGuy.name);
        badGuy.setDeathOrder(this._$2262);
        delegate.reactToAnotherRobotDeath(event, badGuy);
    }

    public void informOfMyDeath(DeathEvent event, ReactionEvents delegate) {
        ++this._$2262;
        this._$2263 = this._$2262;
        delegate.reactToYourDeath(event);
    }

    public int getMyDeathOrder() {
        return this._$2263;
    }

    public void recordSeeingEnemyRobot(ScannedRobotEvent event, ReactionEvents delegate) {
        int index;
        ++this._$1652;
        int n = index = Math.min(Math.abs((int)Math.round(event.getVelocity())), this._$2264.length - 1);
        this._$2264[n] = this._$2264[n] + 1;
        Enemy badGuy = this.findEnemy(event.getName());
        badGuy.registerDataFromEvent((Event)event);
        delegate.reactToSeeingEnemyRobot(event, badGuy);
    }

    public int getInitialCompetitorCount() {
        return this._$2259;
    }

    public double getCompetitorAlivePercentage() {
        return (double)this.myBot.getOthers() / (double)this._$2259 * 100.0;
    }

    public boolean isCompetitionOneOnOne() {
        return this.myBot.getOthers() == 1;
    }

    public boolean isCompetitionThreesome() {
        return this.myBot.getOthers() == 2;
    }

    public boolean isCompetitionMeleeMob() {
        return this.myBot.getOthers() > 2;
    }

    public int getActualAliveCompetitorCount() {
        return this.myBot.getOthers();
    }

    public int getTrackedAliveCompetitorCount() {
        return this._$2260.size();
    }

    public int getTrackedAllCompetitorCount() {
        return this._$2260.size() + this._$2261.size();
    }
}

