/*
 * Decompiled with CFR 0.152.
 */
package dcs;

public class Stampede_TargetData_Mini {
    public String name;
    public double energy;
    public double bearing;
    public boolean refresh;
    public double oldEnergy;

    public void refreshData(double h, double s, double e, double d, double b, double x1, double y1, long time, double x2, double y2) {
        this.bearing = Stampede_TargetData_Mini.absbearing(x2, y2, x1, y1);
        this.refresh = false;
        this.oldEnergy = this.energy;
        this.energy = e;
    }

    public static double calcX(double x1, double bearing, double distance) {
        return x1 + Math.sin(Math.toRadians(bearing)) * distance;
    }

    public static double calcY(double y1, double bearing, double distance) {
        return y1 + Math.cos(Math.toRadians(bearing)) * distance;
    }

    public static double calcDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        if (xo > 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.asin(xo / h));
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI - Math.asin(xo / h));
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.toDegrees(Math.PI + Math.asin(-xo / h));
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.toDegrees(Math.PI * 2 - Math.asin(-xo / h));
        }
        return 0.0;
    }

    public Stampede_TargetData_Mini(String n, double h, double s, double e, double d, double b, double x1, double y1, long time, double x2, double y2) {
        this.name = n;
        this.energy = e;
        this.bearing = Stampede_TargetData_Mini.absbearing(x2, y2, x1, y1);
        this.refresh = false;
        this.oldEnergy = this.energy = e;
    }
}

