/*
 * Decompiled with CFR 0.152.
 */
package josago;

import josago.DatoRobot;

public class InfoRobot {
    private static final int DATOS_MAXIMOS_GUARDADOS = 100;
    private static final double DATOS_UMBRAL_ERROR_PATRON = 1.0E-9;
    public DatoRobot[] datos = new DatoRobot[100];
    public int datosGuardados = 0;
    public final String nombre;
    public double anguloDiferenciaPatron;

    public InfoRobot(String nombre) {
        this.nombre = nombre;
    }

    public void actualizar(double x_robot, double y_robot, double orientacion_robot, double energia_robot, double velocidad_robot, long tiempo) {
        if (this.datosGuardados == 0 || this.datos[0].t != tiempo) {
            for (int i = 99; i > 0; --i) {
                this.datos[i] = this.datos[i - 1];
            }
            this.datos[0] = new DatoRobot(x_robot, y_robot, orientacion_robot, energia_robot, velocidad_robot, tiempo);
            if (this.datosGuardados < 100) {
                ++this.datosGuardados;
            }
        }
    }

    public int indicePatron(int longitud_ventana) {
        int mejor_indice = -1;
        double mejor_error = Double.POSITIVE_INFINITY;
        for (int i = this.datosGuardados - 1; i > longitud_ventana * 2 - 1; --i) {
            double error = 0.0;
            double angulo_diferencia = 0.0;
            for (int j = 0; j < longitud_ventana - 1; ++j) {
                if (this.datos[i - j - 1].t - this.datos[i - j].t != this.datos[longitud_ventana - j - 2].t - this.datos[longitud_ventana - j - 1].t) {
                    error = Double.POSITIVE_INFINITY;
                    continue;
                }
                double aumento_x_historial = this.datos[i - j - 1].x - this.datos[i - j].x;
                double aumento_y_historial = this.datos[i - j - 1].y - this.datos[i - j].y;
                double argumento_historial = Math.sqrt(Math.pow(aumento_x_historial, 2.0) + Math.pow(aumento_y_historial, 2.0));
                double angulo_historial = Math.atan2(aumento_x_historial, aumento_y_historial);
                double aumento_x_ventana = this.datos[longitud_ventana - j - 2].x - this.datos[longitud_ventana - j - 1].x;
                double aumento_y_ventana = this.datos[longitud_ventana - j - 2].y - this.datos[longitud_ventana - j - 1].y;
                double argumento_ventana = Math.sqrt(Math.pow(aumento_x_ventana, 2.0) + Math.pow(aumento_y_ventana, 2.0));
                double angulo_ventana = Math.atan2(aumento_x_ventana, aumento_y_ventana);
                if (j == 0) {
                    angulo_diferencia = angulo_ventana - angulo_historial;
                }
                error += Math.sqrt(Math.pow(argumento_ventana * Math.sin(angulo_ventana -= angulo_diferencia) - aumento_x_historial, 2.0) + Math.pow(argumento_ventana * Math.cos(angulo_ventana) - aumento_y_historial, 2.0));
            }
            if (!((error /= (double)(longitud_ventana - 1)) < mejor_error)) continue;
            mejor_indice = i - longitud_ventana;
            mejor_error = error;
            this.anguloDiferenciaPatron = angulo_diferencia;
            if (!(mejor_error < 1.0E-9)) continue;
            return mejor_indice;
        }
        return mejor_indice;
    }
}

