/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Stampede2;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import wcsv.Stampede2.ExperimentalGun;
import wcsv.Stampede2.ExperimentalMove;
import wcsv.Stampede2.target;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Stampede2
extends AdvancedRobot {
    private static ExperimentalGun S2Gun = new ExperimentalGun(true);
    private static ExperimentalMove S2Move = new ExperimentalMove();
    private static target enemy = null;
    private static double firePower = 1.5;
    private static int hits = 0;
    private static int misses = 0;
    private static final boolean GUN_IS_ACTIVE = true;
    private static final boolean MOVE_IS_ACTIVE = true;
    public ScannedRobotEvent newestScan;
    boolean aim;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setColors(Color.red.darker().darker(), Color.red, Color.orange);
        enemy = null;
        S2Gun.clearLists();
        S2Move.reset(this);
        while (true) {
            if (this.newestScan != null && this.newestScan.getTime() == this.getTime()) {
                this.handleScan(this.newestScan);
                if (enemy != null && this.getEnergy() > 0.0) {
                    this.calcFirePower();
                    S2Gun.fireWave(enemy, this.getX(), this.getY(), this.getHeading(), firePower, this.getTime() - 1L);
                    S2Gun.testWaves(enemy, true);
                    if (this.getGunHeat() > this.getGunCoolingRate()) {
                        this.centerGun();
                        this.aim = false;
                    } else if (this.aim && Math.abs(this.getGunTurnRemaining()) < 0.1 && this.setFireBullet(firePower) != null) {
                        this.aim = false;
                    } else {
                        this.aimGun();
                        this.aim = true;
                    }
                }
                if (enemy != null) {
                    S2Move.refresh(enemy);
                    if (Stampede2.S2Move.lastFirePower > 0.0 && Stampede2.S2Move.lastFirePower <= (double)3) {
                        S2Move.enemyFiredBullet(Stampede2.S2Move.lastFirePower);
                    }
                    if (Stampede2.S2Move.bulletHit != null) {
                        S2Move.hitByBullet();
                    }
                    S2Move.testWaveCompletion();
                    S2Move.doMove(enemy);
                }
            }
            this.doRadar();
            this.execute();
        }
    }

    public void doRadar() {
        if (enemy == null || Stampede2.enemy.data.getTime() <= this.getTime() - (long)3) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        } else {
            double rAngle = target.normalRelativeAngle(Stampede2.enemy.bearing - this.getRadarHeading());
            if (rAngle > 0.0) {
                this.setTurnRadarRight(rAngle + 8.0);
            } else {
                this.setTurnRadarRight(rAngle - 8.0);
            }
        }
    }

    public void calcFirePower() {
        firePower = Math.max(650.0 / Stampede2.enemy.data.getDistance(), (double)2);
        if (Stampede2.enemy.data.getEnergy() <= (double)4 || this.getEnergy() <= (double)4) {
            firePower = 0.2;
        }
    }

    public void aimGun() {
        double bestOffset = S2Gun.getOffset(enemy, firePower, true);
        if (Stampede2.enemy.data.getEnergy() <= 0.0) {
            bestOffset = 0.0;
        }
        double GunAngle = target.normalRelativeAngle(Stampede2.enemy.bearing + Math.toDegrees(bestOffset * ExperimentalGun.MAX_BEARING) - this.getGunHeading());
        this.setTurnGunRight(GunAngle);
    }

    public void centerGun() {
        double GunAngle = target.normalRelativeAngle(Stampede2.enemy.bearing - this.getGunHeading());
        this.setTurnGunRight(GunAngle);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("Skip");
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit Wall");
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Stampede2.S2Move.bulletHit = e.getBullet();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.newestScan = e;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(Stampede2.enemy.data.getName())) {
            enemy = null;
        }
        if (this.getOthers() == 0) {
            S2Gun.clearLists();
        }
        System.out.println("Hits = " + Integer.toString(hits));
        System.out.println("Misses = " + Integer.toString(misses));
        System.out.println("Hit% = " + Double.toString((double)hits / (double)(misses + hits)));
    }

    public void onBulletHit(BulletHitEvent e) {
        ++hits;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++misses;
    }

    public void handleScan(ScannedRobotEvent e) {
        if (enemy == null) {
            enemy = new target(e, this.getHeading(), this.getX(), this.getY());
        } else {
            enemy.refresh(e, this.getHeading(), this.getX(), this.getY());
        }
        Stampede2.S2Move.lastFirePower = Stampede2.enemy.oldData.getEnergy() - Stampede2.enemy.data.getEnergy();
    }

    private final /* synthetic */ void this() {
        this.aim = false;
    }

    public Stampede2() {
        this.this();
    }
}

