package amk.jointstrike;	
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Random;

/**
* JointStrike
*/
public class JointStrike extends TeamRobot
{
        /**
        * run: SnippetBot's default behavior
        */
        OldEnemy target;					//our current enemy
        final double PI = Math.PI;			//just a constant
        int direction = 1;				//direction we are heading...1 = forward, -1 = backwards
        double firePower;       			//the power of the shot we will be using - set by do firePower()
		Random generator = new Random();

        public void run() {
                target = new OldEnemy();
                target.distance = 100000;			//initialise the distance so that we can select a target
				setColors(Color.black,new Color(0,50,100),new Color(150,150,150));

                //the next two lines mean that the turns of the robot, gun and radar are independant
                setAdjustGunForRobotTurn(true);
                setAdjustRadarForGunTurn(true);
				setAdjustRadarForRobotTurn(true);
                turnRadarRightRadians(2*PI);			//turns the radar right around to get a view of the field
                while(true) {
						setTurnRight(90);
						setAhead(40000);
                        doMovement();				//Move the bot
                        doFirePower();				//select the fire power to use
                        doScanner();				//Oscillate the scanner over the bot
                        doGun();
                        fire(firePower);
                        execute();				//execute all commands
                }
        }

        void doFirePower() {
                firePower = 400/target.distance;//selects a bullet power based on our distance away from the target
        }

		public void doMovement() {
			int movementType = generator.nextInt(8);
			if(movementType == 0) {
				setTurnRight(generator.nextInt(45)+46);
				setAhead(40000);
			} else if(movementType == 1) {
				setTurnLeft(generator.nextInt(90)+91);
				setAhead(40000);
			} else if(movementType == 2) {
				setTurnLeft(generator.nextInt(45)+46);
				setAhead(40000);
			} else if(movementType == 3) {
				int degrees = generator.nextInt(359);
				setTurnRight(degrees);
				setAhead(40000);
			} else if ((movementType >= 4) & (movementType <= 6)) {
				int newVelocity = generator.nextInt(4);
				setMaxVelocity(newVelocity+5);
			} else {}
		}

        void doScanner() {
                double radarOffset;
                if (getTime() - target.ctime > 2) { 	//if we haven't seen anybody for a bit....
                        radarOffset = 360;		//rotate the radar to find a target
                } else {

                        //next is the amount we need to rotate the radar by to scan where the target is now
                        radarOffset = getRadarHeadingRadians() - absbearing(getX(),getY(),target.x,target.y);

                        //this adds or subtracts small amounts from the bearing for the radar to produce the wobbling
                        //and make sure we don't lose the target
                        if (radarOffset < 0)
                        radarOffset -= PI/8;
                        else
                        radarOffset += PI/8;
                }
                //turn the radar
                setTurnRadarLeftRadians(NormaliseBearing(radarOffset));
        }

        void doGun() {

                //works out how long it would take a bullet to travel to where the enemy is *now*
                //this is the best estimation we have
                long time = getTime() + (int)(target.distance/(20-(3*firePower)));

                //offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
                double gunOffset = getGunHeadingRadians() - absbearing(getX(),getY(),target.guessX(time),target.guessY(time));
                setTurnGunLeftRadians(NormaliseBearing(gunOffset));
        }


        //if a bearing is not within the -pi to pi range, alters it to provide the shortest angle
        double NormaliseBearing(double ang) {
                if (ang > PI)
                ang -= 2*PI;
                if (ang < -PI)
                ang += 2*PI;
                return ang;
        }

        //if a heading is not within the 0 to 2pi range, alters it to provide the shortest angle
        double NormaliseHeading(double ang) {
                if (ang > 2*PI)
                ang -= 2*PI;
                if (ang < 0)
                ang += 2*PI;
                return ang;
        }

        //returns the distance between two x,y coordinates
        public double getrange( double x1,double y1, double x2,double y2 )
        {
                double xo = x2-x1;
                double yo = y2-y1;
                double h = Math.sqrt( xo*xo + yo*yo );
                return h;
        }

        //gets the absolute bearing between to x,y coordinates
        public double absbearing( double x1,double y1, double x2,double y2 )
        {
                double xo = x2-x1;
                double yo = y2-y1;
                double h = getrange( x1,y1, x2,y2 );
                if( xo > 0 && yo > 0 )
                {
                        return Math.asin( xo / h );
                }
                if( xo > 0 && yo < 0 )
                {
                        return Math.PI - Math.asin( xo / h );
                }
                if( xo < 0 && yo < 0 )
                {
                        return Math.PI + Math.asin( -xo / h );
                }
                if( xo < 0 && yo > 0 )
                {
                        return 2.0*Math.PI - Math.asin( -xo / h );
                }
                return 0;
        }


        /**
        * onScannedRobot: What to do when you see another robot
        */
        public void onScannedRobot(ScannedRobotEvent e) {
                if(isTeammate(e.getName())) {
					return;
				}

                double bulletPower = Math.min(2.0,getEnergy());
				double myX = getX();
				double myY = getY();
				double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
				double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
				double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
				double enemyHeading = e.getHeadingRadians();
				double enemyVelocity = e.getVelocity();
				
				
				double deltaTime = 0;
				double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
				double predictedX = enemyX, predictedY = enemyY;
				while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
					predictedX += Math.sin(enemyHeading) * enemyVelocity;	
					predictedY += Math.cos(enemyHeading) * enemyVelocity;
					if(	predictedX < 18.0 
						|| predictedY < 18.0
						|| predictedX > battleFieldWidth - 18.0
						|| predictedY > battleFieldHeight - 18.0){
						predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
						predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
						break;
					}
				}
				double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
				
				setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
				setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
				setFire(bulletPower);
				setFire(bulletPower);
				execute();
        }

	    public void onHitByBullet(HitByBulletEvent e) {
	        // Evasive action
	        turnLeft( smallestToParallel(90 - e.getBearing()));
	        setAhead(40000);
			doMovement();
			execute();
	    }

    	/**
	     * onHitWallt:  Get away from it
	     */
	    public void onHitWall(HitWallEvent e) {
	        setAhead(-40000); // push off the wall
			doMovement();
			execute();
	    } 
	
	    public double smallestToParallel(double angle) {
	        if (angle > -90 && angle <= 90)
	            return angle;
	        double fixedAngle = angle;
	        while (fixedAngle <= -90)
	            fixedAngle += 180;
	        while (fixedAngle > 90)
	            fixedAngle -= 180;
	        return fixedAngle;
	    }

        public void onRobotDeath(RobotDeathEvent e) {
                if (e.getName() == target.name)
                target.distance = 10000; //this will effectively make it search for a new target
        }

}

class OldEnemy {
        /*
        * ok, we should really be using accessors and mutators here,
        * (i.e getName() and setName()) but life's too short.
        */
        String name;
        public double bearing;
        public double head;
        public long ctime; //game time that the scan was produced
        public double speed;
        public double x,y;
        public double distance;
        public double guessX(long when)
        {
                long diff = when - ctime;
                return x+Math.sin(head)*speed*diff;
        }
        public double guessY(long when)
        {
                long diff = when - ctime;
                return y+Math.cos(head)*speed*diff;
        }

}
