package bvh.tyr;

import robocode.*;
import java.util.*;
import java.awt.Color;

/**
 * Tyr - a robot by Bart van Hest
 *
 *    "Tyr was the god of war and athletic sports. Tyr had one hand bitten off
 *     by the wolf Fenris, after he put it in the wolve's mouth as a pledge of
 *     security when the wolf allowed himself to be bound in a net until the
 *     judgement day."
 *
 * Wijzigingshistorie v1.73 (27-01-2003):
 *  - verbeterde afhandeling inkomende kogels
 *
 * Wijzigingshistorie v1.72 (17-12-2002):
 *  - OnRobotDeath() volgorde acties verbeterd.
 *  - Ram-bewegingsmode verwijderd
 *  - berekening tijdstip volgende stap o.b.v. afstand tot doel ipv loopsafstand
 *  - eerder in verdedigingsmode, later in aanvalsmode
 *  - bij ontwijken kogel weer af en toe bewegingsrichting omkeren
 *
 * Wijzigingshistorie v1.71 (25-12-2002):
 *  - max. op kogel energie op 3 gezet
 *  - extra condities toegevoegd wanneer kan worden geschoten
 *
 * Wijzigingshistorie v1.7 (17-12-2002):
 *  - teller voor ingeslagen kogels toegevoegd die bewegingsmode in verdediging zet.
 *
 * Wijzigingshistorie v1.6 (23-11-2002):
 *  - wandontwijking uit Sleipnir overgenomen.
 *
 * Wijzigingshistorie v1.52 (20-11-2002):
 *  - kleine verbetering in ontwijkWanden() teruggedraaid, want was verslechtering!
 *
 * Wijzigingshistorie v1.51 (15-11-2002):
 *  - kleine verbetering in ontwijkWanden()
 *
 * Wijzigingshistorie v1.5 (03-11-2002):
 *  - combinatie van bewegingsmodus v1.3 en kogel ontwijking v1.4: verslaat Tyr 1.3!!!
 *
 * Wijzigingshistorie v1.4 (31-10-2002):
 *  - kogel-object in hashtable met kogels
 *  - 'verbeterde' bewegingsmanager die beroerd uitpakt...
 *
 * Wijzigingshistorie v1.3 (22-10-2002):
 *  - nieuw kogel-object om beter te kunnen uitwijken: verbetering -> array van kogels
 *  - terug naar oude radar-bweging: is beter
 *  - extra radar-zwiep in melee vanuit onScannedRobotEvent
 *  - eenvoudiger bewegingskeuze
 *  - verbeterde aanvals-mode: inclusief random variaties in bewegingssnelheid en afstand.
 *
 * Wijzigingshistorie v1.1 (11-10-2002):
 *  - nieuwe opzet: met bewegings-, doel- en radar-manager: code verdeeld, Tyr
 *    nog even effectief!
 *
 * Wijzigingshistorie v1.0 (11-09-2002):
 *  - top in deze lijn: nu nieuwe architectuur!
 *
 * Wijzigingshistorie v0.4 (10-09-2002):
 *  - tweaks: nu beter in 1vs1 tegen Loki, ook tegen Loki in groepsgevecht tegen bvh-bots,
 *            verder bijna even goed als Aardvark!
 *
 * Wijzigingshistorie v0.3 (06-09-2002):
 *  - wand botsings preventie toegevoegd
 *
 * Wijzigingshistorie v0.2 (30-08-2002):
 *  - volgorde run-routines verbeterd
 *  - groffe fout in aanroep Doel.circulaireBewegingsSchatter verbeterd
 *    (snelheid i.p.v. vliegtijd doorgeven)
 *  - naar/vanaf doel circelen in aanval/verdediging vertraagd.
 *  - vInkomendeKogel berekenen o.b.v. energieverlies doel
 *
 * Wijzigingshistorie v0.1 (28-08-2002):
 *  - gebaseerd op Loki v0.4
 *  - verbeterde doel afstand schatter d.m.v. iteratieve circulaire voorspelling
 *  - uitwijken wanneer inkomende kogel wordt verwacht
 *
 */
public class Tyr extends AdvancedRobot implements Constanten {
/**
* run: Tyr's hoofdroutine:
*/
   public void run() {
      initialisatie(); // initialisatie van mijn Bot:

      while(true) { // levensloop:
         radar.stuurRadar();         // stuur radar aan (zoek doel):
         tank.bepaalBewegingsmode(); // bepaal nieuwe(?) bewegingstoestand:
         tank.navigatie();           // verplaats robot:
         kanon.stuurKannon();        // en stuur kanon aan (richt):
         kanon.vuurKannon();         // en geef vuur:
         execute();
      } // einde levensloop
   } // einde run-method

/**********************************************************************
*  EVENTS
**********************************************************************/
/**
 * onScannedRobot: What to do when you see another robot
 * let op: van alle scanned bots tijdens een radar-sweep wordt de dichtstbijzijnde bot doorgegegeven!
 */
   public void onScannedRobot(ScannedRobotEvent e) {
      if (mijnDoel.naam == null // selecteer doel indien nog geen ander doel gevonden en in hoek gekropen
      ||  mijnDoel.naam == e.getName()      // update doel indien al eerder gevonden
      || (mijnDoel.afstand > e.getDistance() && mijnDoel.e > e.getEnergy()) // selecteer gunstiger doel
      || e.getEnergy() < 15D) { // selecteer zwak doel dat met 1 schot kan worden uitgeschakeld

if (debugMode > 0 && mijnDoel.naam != e.getName()) out.println("nieuw doel:"+e.getName());

         radar.setDoelGevonden(true);
         mijnDoel.setInfo(e, this);  // leg informatie over doel vast:
         if (getOthers() != 1) radar.RadarDraairichtingOmkeren(); // werkt goed in melee: zorgt voor
                                     // semi-radarlock op doel met af en toe een grotere sweep,
                                     // werkt NIET in 1-vs-1 !
      }
   }

/**
* onHitByBullet: What to do when you're hit by a bullet.
*/
   public void onHitByBullet(HitByBulletEvent e) {
      mijnDoel.setAantalIngeslagenKogels(e);
      radar.radar1Vs1( (e.getBearingRadians()+getHeadingRadians()) );
   }

/**
* onHitRobot: What to do when you're hit by a robot.
*/
   public void onHitRobot(HitRobotEvent e) {
      setBack(45);
      turnGunRightRadians(Utils.normaliseBearing(getHeadingRadians() + e.getBearingRadians() - getGunHeadingRadians()));
      fire(3);
   }

/**
* onWin: Niet stil blijven zitten om laatste op mij afgevuurde kogels te ontwijken.
* (zie UltimateDeathToNanoBots)
*/
   public void onWin(WinEvent e) {
      tank.bewegingsrichtingOmkeren();
      tank.omdraaien(correctieRadarDraaicirkel);
   }

/**
* onRobotDeath: Bewegingstoestand resetten wanneer doel is vernietigd.
*/
   public void onRobotDeath(RobotDeathEvent e) {
      setAhead(standaardLoopafstand);
      turnRightRadians(mijnDoel.richting + Math.PI/2D);
      if  (e.getName() == mijnDoel.naam ) resetBot();
   }

/**
* onHitWall:  keer richting om bij borsing met muur (botsing kost energie afhankelijk van botsingssnelheid!!!)
*/
   public void onHitWall(HitWallEvent e) {
      if (tank.bewegingsToestand != INHOEK) {
         double draaicirkel = 0;
         if (getX()<35)             draaicirkel =  Math.PI/4D - getHeadingRadians() ;
         if (getX()>(tank.xMax-35)) draaicirkel = -Math.PI/4D - getHeadingRadians() ;
         if (getY()<35)             draaicirkel = -Math.PI/2D - getHeadingRadians() ;
         if (getY()>(tank.yMax-35)) draaicirkel =  Math.PI/2D - getHeadingRadians() ;

         tank.bewegingsrichtingOmkeren();
         tank.omdraaien(Utils.normaliseBearing(draaicirkel));
      } else {
         tank.bewegingsrichtingOmkeren();
      }
   }

/**
* onDeath: toon statistiek
*/
   public void onDeath(DeathEvent e) {
      out.println("DOOD: " + beurtOvergeslagen + " keren beurt overgeslagen.");
   }

/**
* onSkippedTurn:  telt aantal keren dat beurt wordt overgeslagen;
*/
   public void onSkippedTurn(SkippedTurnEvent e) {
      beurtOvergeslagen += 1;
   }

/**********************************************************************
*  ALGEMEEN
**********************************************************************/
   public void initialisatie() {
      out.println("\n---===[ Tyr (ver. 1.73) by Loki ]===---");
      setColors(Color.blue,Color.blue,Color.yellow); // mijn strijdkleuren

      setAdjustGunForRobotTurn(adjustGun);
      setAdjustRadarForGunTurn(adjustRadar);

      mijnDoel = new Doel(this); // doel alvast aanmaken en initieren; ik vind er wel een!
      tank     = new BewegingsManager(this, mijnDoel);
      radar    = new RadarManager(this, mijnDoel);
      kanon    = new KanonManager(this, mijnDoel);

      resetBot();
   }

   public void resetBot() {
      tank.botDraaicirkel   = 2*standaardDraaicirkel;
      tank.botLoopafstand   = standaardLoopafstand;
      tank.bewegingsToestand= RANDOM;

      radar.doelGevonden    = false;
//      mijnDoel              = null;

      mijnDoel.resetInfo();
if (debugMode > 0) out.println("vergeet doel: ");
   }

/**********************************************************************
** Definitie van variabelen
**********************************************************************/
// managers:
   BewegingsManager  tank;
   RadarManager      radar;
   KanonManager      kanon;

// variabelen voor kanon:
   boolean adjustGun         = true; // kanon draait in tegengestelde richting als bot: blijft daardoor oorspronkelijke richting behouden

// variabelen voor radar:
   boolean adjustRadar       = true; // radar draait in tegengestelde richting als bot: blijft daardoor oorspronkelijke richting behouden

// doel variabelen:
   Doel    mijnDoel;

// algemene variabelen:
   int     beurtOvergeslagen = 0;
   int     debugMode         = 0;    // 0: geen debug meldingen,
                                     // 1: doel/schiet-info,
                                     // 2: incl. bewegingsinfo,
                                     // 3: alle info

} // einde Tyr
/**********************************************************************
** EINDE TYR
**********************************************************************/
