package jok;
import robocode.*;
import java.util.*;
import java.awt.geom.*;

/**
 * MyClass - a class by (your name here)
 */
public class MovementAntiGrav extends Movement
{
	private Hashtable targets;
	AdvancedRobot me;
	int midpointcount = 0;
	double strength = 0;
	double sideDistance;
	
	public MovementAntiGrav(AdvancedRobot ar, Hashtable bots)
	{
		me = ar;
		targets = bots;
		sideDistance = Math.min(Math.min(me.getX(),me.getY()),Math.min(me.getBattleFieldWidth()-me.getX(),me.getBattleFieldHeight()-me.getY()));
	}
	
	public void move()
	{
		me.setAhead(10000);
   		double xforce = 0;
	    double yforce = 0;
	    double force;
	    double ang;
	    GravPoint p;
		Enemy en;
    	Enumeration e = targets.elements();

	    // Turns all enemies to repulsive points
		while (e.hasMoreElements())
		{
    	    en = (Enemy)e.nextElement();
			p = new GravPoint(en.getX(),en.getY(), -5000);
		    force = p.power/Math.pow(BotMath.getRange(me.getX(),me.getY(),p.x,p.y),2);
		    //Find the bearing from the point to us
		    ang = BotMath.normaliseBearing(Math.toDegrees(Math.PI/2 - Math.atan2(me.getY() - p.y, me.getX() - p.x))); 
		    //Add the components of this force to the total force in their respective directions
		    xforce += Math.sin(Math.toRadians(ang)) * force;
		    yforce += Math.cos(Math.toRadians(ang)) * force;
	    }

		/**The next section adds a middle point with a random (positive or negative) strength.
		The strength changes every 5 turns, and goes between -1000 and 1000.  This gives a better
		overall movement.**/

		midpointcount++;
		if (midpointcount > 5) {
			midpointcount = 0;
			strength = (Math.random() * 2000) - 1000;
		}
		p = new GravPoint(me.getBattleFieldWidth()*Math.random(), me.getBattleFieldHeight()*Math.random(), strength);
		force = p.power/Math.pow(BotMath.getRange(me.getX(),me.getY(),p.x,p.y),1.5);
	    ang = BotMath.normaliseBearing(Math.toDegrees(Math.PI/2 - Math.atan2(me.getY() - p.y, me.getX() - p.x))); 
	    xforce += Math.sin(Math.toRadians(ang)) * force;
	    yforce += Math.cos(Math.toRadians(ang)) * force;


	    // Wall Avoidance
		xforce += 50000/Math.pow(BotMath.getRange(me.getX(), me.getY(), me.getBattleFieldWidth(), me.getY()), 3);
	    xforce -= 50000/Math.pow(BotMath.getRange(me.getX(), me.getY(), 0, me.getY()), 3);
	    yforce += 50000/Math.pow(BotMath.getRange(me.getX(), me.getY(), me.getX(), me.getBattleFieldHeight()), 3);
	    yforce -= 50000/Math.pow(BotMath.getRange(me.getX(), me.getY(), me.getX(), 0), 3);

	    // Move in the direction of our resolved force.
	    double angle = BotMath.absbearing(me.getX(),me.getY(),me.getX()-xforce,me.getY()-yforce);
		angle = BotMath.normaliseBearing(me.getHeading() - angle);
		me.setTurnLeft(angle);
		me.setMaxVelocity(8-Math.random()-Math.min(150/sideDistance,3));
	}
}

/**Holds the x, y, and strength info of a gravity point**/
class GravPoint {
    public double x,y,power;
    public GravPoint(double pX,double pY,double pPower) {
        x = pX;
        y = pY;
        power = pPower;
    }
}
