/*
 * Relativity.java
 *
 * Created on 6 october 2001, 12:44
 */

package tobe;
import robocode.*;
import tobe.util.*;
import tobe.movement.*;
import tobe.firing.*;
import java.awt.Color;

/**
 *
 * @author  Torbjrn Gannholm
 * @version alpha
 *
 * A robot using negative gravity to avoid hard things like robots
 * and walls, until there is only one opponent left. Then...
 *
 * Changes from 3.8
 * made things static to reintroduce learning
 * cleaner firing code
 *
 * Changes from 3.7
 * Added jump prediction
 *
 * Changes from 3.0:
 * 3_4:
 * Improved firing strategy in multibot.
 * Improved AntiMatter movement
 * 3_7:
 * reworked firing
 * introduced good radar control
 * Weave movement now tries to dodge bullets (but not flea-bites)
 * Improved starting movement in Weave
 *
 * Changes from 2.0:
 * Fires less in multi-bot battles
 * MultiPredictor firing can handle more than one enemy
 * Improved prediction in MultiPredictor
 * AntiMatter movement more random
 *
 *Changes from 1.2:
 *Added Predictor firing for 1-on-1
 *Improved Weave movement
 *Increased speed of firing
 *
 * Changes from 1.0:
 * AntiGravity better at avoiding walls
 * Weave rewritten to BearingVectors and improved
 *
 * Feel free to use this code. I would like it very much if derived code
 * is published (as in the GPL). A credit would also be nice...
 */
public class Relativity extends AdvancedRobot {
    
    final public void onCustomEvent(robocode.CustomEvent customEvent) {
        if(firing != null) firing.handleCustomEvent(this, customEvent);
        if(moving != null) moving.handleCustomEvent(this, customEvent);
    }
    
    final public void onBulletHit(robocode.BulletHitEvent bulletHitEvent) {
        if(firing != null) firing.handleBulletHitEvent(this, bulletHitEvent);
        if(moving != null) moving.handleBulletHitEvent(this, bulletHitEvent);
        if(moving != victory) lastActivityTime = getTime();
    }
    
    final public void onBulletHitBullet(robocode.BulletHitBulletEvent e) {
        if(moving != victory) lastActivityTime = getTime();
    }
    
    final public void onBulletMissed(robocode.BulletMissedEvent bulletMissedEvent) {
        if(firing != null) firing.handleBulletMissedEvent(this, bulletMissedEvent);
        if(moving != null) moving.handleBulletMissedEvent(this, bulletMissedEvent);
        if(moving != victory) lastActivityTime = getTime();
    }
    
    final public void onDeath(robocode.DeathEvent deathEvent) {
        if(firing != null) firing.handleDeathEvent(this, deathEvent);
        if(moving != null) moving.handleDeathEvent(this, deathEvent);
    }
    
    final public void onHitByBullet(robocode.HitByBulletEvent hitByBulletEvent) {
        if(firing != null) firing.handleHitByBulletEvent(this, hitByBulletEvent);
        if(moving != null) moving.handleHitByBulletEvent(this, hitByBulletEvent);
        if(moving != victory) lastActivityTime = getTime();
    }
    
    final public void onHitRobot(robocode.HitRobotEvent hitRobotEvent) {
        if(firing != null) firing.handleHitRobotEvent(this, hitRobotEvent);
        if(moving != null) moving.handleHitRobotEvent(this, hitRobotEvent);
    }
    
    final public void onHitWall(robocode.HitWallEvent hitWallEvent) {
        if(firing != null) firing.handleHitWallEvent(this, hitWallEvent);
        if(moving != null) moving.handleHitWallEvent(this, hitWallEvent);
    }
    
    final public void onRobotDeath(robocode.RobotDeathEvent robotDeathEvent) {
        if(firing != null) firing.handleRobotDeathEvent(this, robotDeathEvent);
        if(moving != null) moving.handleRobotDeathEvent(this, robotDeathEvent);
        pickMovement();
        pickFiring();
    }
    
    final public void onScannedRobot(robocode.ScannedRobotEvent scannedRobotEvent) {
        if(firing != null) firing.handleScannedRobotEvent(this, scannedRobotEvent);
        if(moving != null) moving.handleScannedRobotEvent(this, scannedRobotEvent);
        ScannedRobotEvent previous = (ScannedRobotEvent) scans.get(scannedRobotEvent.getName());
        if(previous != null && previous.getEnergy() < scannedRobotEvent.getEnergy())
            if(moving != victory) lastActivityTime = scannedRobotEvent.getTime();
        scans.put(scannedRobotEvent.getName(), scannedRobotEvent);
    }
    
    final public void onWin(robocode.WinEvent winEvent) {
        if(firing != null) firing.handleWinEvent(this, winEvent);
        if(moving != null) moving.handleWinEvent(this, winEvent);
    }
    
    private void pickFiring() {
        if(getOthers() > 1){
            if(firing == predictor) return;
            firing = predictor;
        } else if(getOthers() > 0){
            if(firing == predictor_alpha) return;
            firing = predictor_alpha;
        } else {
            firing = victory;
            return;//already inited
        }
        if(firing != null) firing.init(this);
    }
    
    private void pickMovement() {
	    out.println("fighting "+getOthers()+" other bots");
        if(moving == victory) return;
        if( getOthers() > 2) {
            if(moving == antimatter) return;
            moving = antimatter;
        } else if( getOthers() > 0) {
            if(moving == weave) return;
            moving = weave;
        } else {
            lastActivityTime = getTime()+1000;
            moving = victory;
        }
        moving.init(this);
    }
    
    /** the field that holds the firing Strategy */
    protected AbstractStrategy firing = null;
    // my firing strategies
    static AbstractStrategy predictor = new JumpPredictor(false);
    static AbstractStrategy predictor_alpha = new JumpPredictor(true);
    
    /** the field that holds the moving Strategy */
    protected AbstractStrategy moving = null;
    //the movement strategies I have
    static AbstractStrategy antimatter = new AntiMatter();
    static AbstractStrategy weave = new NewWeave_1();
    static AbstractStrategy victory = new Victory();
    
    static final int INACTIVITY_TIME = 50;
    private double lastActivityTime;
    private java.util.HashMap scans = new java.util.HashMap();
    
    final public void run() {
        //zero
		setColors(new Color(190,150,255), Color.black, Color.red);
        moving = null;
        firing = null;
        lastActivityTime = 0;
        pickMovement();
        pickFiring();
        //Thread fireThread = new Thread( new ThreadedStrategy(firing, this) );
        //fireThread.start();
        while( true ) {
            if(getTime() > lastActivityTime + INACTIVITY_TIME*getOthers()) {
                if(moving != weave) {
                    moving = weave;
                    moving.init(this);
                }
                //just to keep game alive!
                fire(0.1);
            }
            moving.go(this);
            firing.go(this);
            execute();
        }
    }
    
}
    
