package shinh;

import robocode.*;

import java.awt.geom.Point2D;

public class PredictArc {
	private static PredictLinear linear_ = new PredictLinear();

	private double lastHeading_;
	private long lastTurn_;
	private double changeHead_;

	public String name() {
		return "arc";
	}

	public void doMove(Being ene) {
		double radius = ene.velocity / changeHead_;
		ene.x +=
			(Math.sin(ene.heading) -
			 Math.sin(ene.heading + changeHead_)) * radius;
		ene.y +=
			(Math.cos(ene.heading) -
			 Math.cos(ene.heading + changeHead_)) * radius;
	}

	public Point2D.Double guessPosition(Being ene, double diff) {
		Entangled ent = Entangled.me;

		/**time is when our scan data was produced.  when is the time
		   that we think the bullet will reach the target.  diff is the
		   difference between the two **/
		double newX, newY;
		/**if there is a significant change in heading, use circular
		   path prediction**/
		if (Math.abs(changeHead_) > 0.00001) {
			double radius = ene.velocity / changeHead_;
			double tothead = diff * changeHead_;
			newY = ene.y + (Math.sin(ene.heading + tothead) * radius) -
				(Math.sin(ene.heading) * radius);
			newX = ene.x + (Math.cos(ene.heading) * radius) -
				(Math.cos(ene.heading + tothead) * radius);
		}
		/**if the change in heading is insignificant, use linear
		   path prediction**/
		else {
			newY = ene.y + Math.cos(ene.heading) * ene.velocity * diff;
			newX = ene.x + Math.sin(ene.heading) * ene.velocity * diff;
		}
		return new Point2D.Double(newX, newY);
	}

	public Point2D.Double getFuturePnt(Being ene, double pow) {
		Entangled ent = Entangled.me;

		changeHead_ =
			Util.getNormalRadian(ene.heading - lastHeading_) /
			(ent.getTime() - lastTurn_);

		if (changeHead_ < 0.00001) {
			return linear_.getFuturePnt(ene, pow);
		}

		double bspd = 20 - (3 * pow);

		long nextTime;
		Point2D.Double p = new Point2D.Double(ene.x, ene.y);
		for (int i = 0; i < 10; i++){
			nextTime =
				(Math.round((Util.distance(ent.getX(),ent.getY(),p.x,p.y) /
							 bspd)));
			p = guessPosition(ene, nextTime);
		}

		return p;
	}

	public void pushState(Being enemy) {
		lastHeading_ = enemy.heading;
		lastTurn_ = enemy.turn;
	}
}
