package povik.nano;
import robocode.*;
// import robocode.util.*;
// import java.awt.*;
// import java.awt.geom.*;
// import java.util.*;

/**
 * Smilee 0.2.1
 * 1v1
 * nano
 */
public class Smilee extends AdvancedRobot
{
	double BULLET_ENERGY = 1.9;
	double BULLET_SPEED = 20 - 3*BULLET_ENERGY;
	double enemyBearing;
	double enemyDistance;
	double enemyOffset;
	double waveTime;
	double waveBearing;
	int direction = 300;
		
	public void run() {
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		
		while (true) {
			setTurnRight(normalRelativeAngle(enemyBearing - getHeading() + 90));
			setTurnGunRight(normalRelativeAngle(enemyBearing - getGunHeading() + enemyOffset));
			setFire(BULLET_ENERGY);
			
			if (waveTime <= getTime()) {
				enemyOffset = enemyBearing - waveBearing;
				waveTime = getTime() + enemyDistance / BULLET_SPEED;
				waveBearing = enemyBearing;
			}
			
			setAhead(direction);
			if (Math.random() > 0.7)
				direction *= -1;
				
			execute();
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
		enemyBearing = e.getBearing() + getHeading();
		enemyDistance = e.getDistance();
	}

	public double normalRelativeAngle(double angle) {
		while (angle > 180) angle -= 360;
		while (angle < -180) angle += 360;
		return angle;
	}
}
